//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_report_memory.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Server ReportMemory base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 27.10.05  | ESA2 Barber                  | Initial version
// 29.10.12  | BSOT Plischke                | new Diaglog
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_memory
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_memory

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_system_variables
   #include <common/framework/vd_diaglog_system_variables.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_qualification
   #include <common/framework/vd_diaglog_qualification.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_interface
   #include <common/framework/vd_diaglog_storage_interface.h>
#endif


// Format must be changed if g_oaDtcDefinitionTable is modified
#define DIAGLOG_MEMORY_VERSION_FORMAT  4


class vdl_tclPluginBaseClass; //lint !e763
class vdl_tclAgeing;          //lint !e763
class vdl_tclSingleAgeing;    //lint !e763

namespace VDD
{
   class ExtendedData;        //lint !e763
}// namespace VDD


// class to encapsulate the report memory database 
class vdl_tclReportMemory : public vdl_tclGlobalSystemVariables,
                            public vdl_tclStorageUserInterface,
                            public vdl_tclQualificationCallbackInterface
{
private:
   friend class vdl_tclSingleAgeing;
   vdl_tclReportMemory();  //lint !e1704 // do not use so made as private
// construction /destruction
public:
   vdl_tclReportMemory(tU8 Id, tCString acMemoryFile, int size, const trReportRecordData* pConstDataArray);
   virtual ~vdl_tclReportMemory();

private:
   tU8                              m_MemoryId; 
   tReportArray                     m_oReports;
   tU8                              m_u8GlobalAgeingCounter;
   tU32                             m_u32LastReportedDTC;              //This is he last DTC that has been reported. 
                                                                       //Checking the DTCs for Triggered Messages the next Transmission period shall start with this DTC 
   tU32                             m_u32StatOfLastReportedDTC;
   vdl_tclAgeing*                   m_pAgeingAlgorithm;                //lint -sem(vdl_tclReportMemory::vDestroy,cleanup)
   tU16                             m_u16NumberOfDynamicITCs;
   vdl_tclReportRecordConstData     m_reportRecordConstData;
   vdl_tclQualificationBase*        m_poQualificationObject;
   std::vector<tU32>              m_activeDTCList;


// operations
public:
   tU8   u8GetMemoryId() const {return m_MemoryId;};

   tU16 getFirstActiveITC();    // needed for global ageing
   bool isAnyItcActiveOrHistory();

   tVoid vProcessOnInit();
   tVoid processSystemEvent(vdl_teDiaglogSystemEvent systemEvent);

   tVoid vOnExternalAgeingCounter(tU8 AgeingCounter);
   tBool processClearRequest(tU32 u32DtcMask, tITCVector& ITCs);
   tS8 vProcessReadPriority(tReadReportListDM1& DM1List);
   tVoid vProcessReadRequest(tReadReportListArray&      roReadResult,
                             tU32 const                 u32StatusMask,
                             tU32 const                 u32ITCMask,
                             vdl_teDiaglogOptions const   eOption) const;
   tVoid vProcessReadNumberOfDtcByStatusMask(  tU32&        u32NumberOfDTC,
                                               tU32 const   u32StatusMask);

   tVoid vProcessReadLastConfirmedDTC(tReadReportListArray&      roReadResult) const;
   tVoid vProcessReadSupportedDTCs(tReadReportListArray&      roReadResult);
   bool bProcessTestReport(tU16 u16IUC, vdl_teDiaglogReportMsg eStatus);
   bool bProcessTestReport(vdl_tsDiaglogTestResult oTestResult);
   bool bProcessControlCommand(vdl_teDiaglogControlMsg eControlCmd, tDTCListArray const& oDTCList);
   tBool bProcessSetToDefault() const;
   vdl_tclReportRecord const*  getReportRecord(tU32 dtc) const;
   tVoid vTraceReports();
   tVoid vDestroy();
   vdl_tclReportRecord* pGetReportRecord(tU16 u16ITC) const;
   VDD::ExtendedData const* getExtendedData(tU32 dtc, tU8 recordNumber) const;
   void  getSnapShotData(tU32 dtc, tU8 recordNumber,tU32& status, tSnapShotDataList& SnapShotDataList) const;
   vdl_tclReportRecord* getMostRecentReportRecordByDTC(tU32 u32DTC)const;
   tU8 getOccuranceCounterByDTC(tU32 u32DTC)const;
   
   void  initialise()   {vAddErrorReports(); vAddAgeingAlgorithm();}
   bool bCheckLoadStatus();
   tVoid vCheckAndSave();
   tVoid vSaveNow();
   tVoid vSetModified();
   tBool getStateOfDTC( tU32 const u32DTCRequest, tU32& state) const;
   tVoid vAgeingCompleted(vdl_tclReportRecord* pReportRecord) const;
   tVoid getItcInformation(tU16 ITC,vdl_tsDiaglogItcInformation& itcInformation);
   vdl_tclReportRecord* getReportRecordForDTC(tU32 aDTC) const;
   tVoid vUpdateActiveDTCList();

   // overridables
#if 0
   virtual tU8 convertStatus(tuRecordStatus internalStatus) const = 0;
   virtual tuRecordStatus convertStatus(tU8 aStatus) const = 0;
   virtual tVoid vProcessReadRequest(tU8 const u8StatusAvailabilityMask, tReadReportListArray&  roReadResult, tU8 const& u8StatusMask, tU32 const& u32DTCMask, vdl_teDiaglogOptions const&   eOption ) const = 0;
   virtual vdl_tclReportRecord* createReportRecord(vdl_tclReportRecordConstData const* constData, tU16 Index) = 0;
   virtual vdl_tclReportRecord* createReportRecord(tU16 u16ITC, tU32 u32DTC) = 0;
#endif
   vdl_tclReportRecord* createReportRecord(vdl_tclReportRecordConstData const* constData, tU16 Index) {return new vdl_tclReportRecord(this, constData, Index);}
   vdl_tclReportRecord* createReportRecord(tU16 u16ITC, tU32 u32DTC) {return new vdl_tclReportRecord(this, u16ITC, u32DTC);}

// implementation

   // vdl_tclStorageUserInterface
   virtual tU8 u8GetDataFormatVerision() const {return DIAGLOG_MEMORY_VERSION_FORMAT;}
   virtual tVoid vSave(tStream&);
   virtual bool bLoad(tStream& roData);
   virtual tVoid vGetSizeOfLoadBuffer(tS32& Max, tS32& Min);

   // vdl_tclQualificationCallbackInterface
   virtual tVoid vFail(vdl_tclReportRecord* const pReportRecord);
   virtual tVoid vFailQualified(vdl_tclReportRecord* const pReportRecord);
   virtual tVoid vPass(vdl_tclReportRecord* const pReportRecord);
   virtual tVoid vPassQualified(vdl_tclReportRecord* const pReportRecord);
   virtual tVoid vQualificationStepFinshed() {vCheckAndSave(); vUpdateActiveDTCList();};
   tVoid vClearAll();
   tReportArrayIt deleteRecordByIter(tReportArrayIt iter);


private:
   inline void LockMemorySemaphore() const;
   inline void FreeMemorySemaphore() const;
   tVoid vManageReport(vdl_tclReportRecord*,vdl_teDiaglogReportMsg);
   tBool bEventStep(vdl_teDiaglogEventStep enEventStep, vdl_tclReportRecord* pReportRecord = NULL) const;
   tBool clearByMask(tU32 u32DtcMask, tITCVector& ITCs);
   bool bIsAlreadyFailed(vdl_tclReportRecord const* pReportRecord) const;
   bool bIsAlreadyPassed(vdl_tclReportRecord const* pReportRecord) const;


   vdl_tclReportRecord* poCreateOverloadRecord(vdl_teDiaglogReportType eReportType,  vdl_tclReportMemory* const pMemoryObject, const vdl_tclReportRecordConstData* pReportRecordConstData, tU16 Index)const;
   tVoid vAddErrorReports();
   tVoid vAddAgeingAlgorithm();
   bool isBlockingModeActive(vdl_tclReportRecord const* pReportRecord,tU32& blockingModeMask) const;
   bool searchAndDeleteRecord(const vdl_tclReportRecord* const pReportRecord);

   tVoid vProcessOperatingCycleStart();
   tVoid vProcessIgnitionCycleStart();
   tVoid vProcessOperatingCycleEnd();
   tVoid vProcessIgnitionCycleEnd();
   tVoid vProcessAccCycleStart();
   tU16 getMaxDynamicDtcs()   {return MAX_NUMBER_OF_DYNAMIC_DATA;}
   bool isDTCActive(tU32) const;
};




#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_memory

