//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_protocol_converter.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: format converter
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 13.04.15  | BSOT Plischke                 | Initial version
//
//////////////////////////////////////////////////////////////////////////

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_protocol_converter
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_protocol_converter

// pure static class
class vdl_tclProtocolConverter
{
private: 
   //GMLAN
   tU8 convertINTERNtoGMLAN(const tuRecordStatus& uRecordStatus)const;
   tuRecordStatus convertGMLANtoINTERN(tU8 aStatus)const;
   //UDS
   tU8 convertINTERNtoUDS(const tuRecordStatus& uRecordStatus)const;
   tuRecordStatus convertUDStoINTERN(tU8 aStatus)const;
public:
   vdl_tclProtocolConverter(){}; 
   ~vdl_tclProtocolConverter(){};

   tU8 convertStatusIntToExt(vdl_teDiaglogReportProtocol format, const tuRecordStatus& recordStatus)const;
   tU8 convertStatusIntToExt(vdl_teDiaglogReportProtocol format, tU32 u32Status)const;
   tuRecordStatus convertStatusExtToInt(vdl_teDiaglogReportProtocol format, tU8 recordStatus)const;

};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_protocol_converter
