/*!
* \file       vd_diaglog_object_manager.h
*
* \brief      Used to persistently save the Dialog object (log) files, makes it transaction safe.
*
* \details    Used to persistently save the Dialog object (log) files, makes it transaction safe.
*
* \component  Diaglog
*
* \ingroup    DiaglogFramework
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef __VD_DIAGLOG_INCLUDEGUARD_OBJECT_MANAGER__
#define __VD_DIAGLOG_INCLUDEGUARD_OBJECT_MANAGER__


class vdDiaglog_ObjManager
{
private:
    //! class constructor
    vdDiaglog_ObjManager() = delete;

public:
    //! class parametrized constructor
    vdDiaglog_ObjManager(tCString logObjectName);
    //! class destructor
    virtual ~vdDiaglog_ObjManager(void);

    //! update diaglog object of type file
    virtual bool updateData(const tStream& iData);
    //! read diaglog object of type file
    virtual bool loadData(tStream& oData);

protected:
    //! default constructor
    //vdDiaglog_ObjManager(void);
    // receate the storage area: main directory, logfile and checksum file.
    bool bReCreateStorageArea(std::string newDir);
    // read the data from the Diaglog object files
    bool readData(tStream& oData, std::string iFile);
    // write the data into the Diaglog object files
    bool writeData(const tStream& iData, std::string iFile );
    // validate the new link is points to a valid directory, return the currDir it points to and the newDir
    // where the data should be written next
    bool validateLink(std::string link, std::string& currDir, std::string& newDir);
    // vefiry the checksum stored is same as checksum for the rData.
    bool validateChecksum(tStream& checksum, tStream& rData);
    // validate the data is correct by verifying checksum.
    bool validateData(std::string otherDir);
    // validate the data is correct by verifying checksum.
    bool validateData(std::string otherDir, tStream rData);
    // calculate checksum and update Checksum File.
    bool calcCRCUpdateChecksumFile(const tStream& iData, std::string chkFile);

private:

    std::string path;
    std::string filename;

    std::string logDirOld;
    std::string logDirNew;
    std::string linkDirOld;
    std::string linkDirNew;

};


#endif /* __VD_DIAGLOG_INCLUDEGUARD_OBJECT_MANAGER__ */
