//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_memory_master.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: this class takes control over all report_memory objects
//
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author                       | Modification
// 17.09.13  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_qualification
   #include <common/framework/vd_diaglog_qualification.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_protocol_converter
   #include <common/framework/vd_diaglog_protocol_converter.h>
#endif

// forward declaration
class vdl_tclPluginBaseClass;

namespace VDD
{
class ExtendedData;
}// namespace VDD

typedef struct
{
   vdl_tclPluginBaseClass* pCallbackClass;
} vdl_tsDiaglogEventRegistration;

// class to encapsulate the report memory database
class vdl_tclMemoryMaster
{
// construction /destruction
public:
   vdl_tclMemoryMaster();
   virtual ~vdl_tclMemoryMaster();

// types
private:
   typedef std::list<vdl_tsDiaglogEventRegistration>                    tEventRegistrationList;
   typedef std::list<vdl_tsDiaglogEventRegistration>::iterator          tEventRegistrationListIt;
   typedef std::list<vdl_tsDiaglogEventRegistration>::const_iterator    tEventRegistrationListCIt;

// attributes
   tEventRegistrationList           m_oEventRegList;
   tMemoryArray                     m_oMemorys;
   static const tMemoryFactory      g_oMemoryFactory[];

public:
   vdl_tclQualificationBase         m_oQualificationList;

// operation
   VDD::ExtendedData const* getExtendedData(tU8 group, tU32 dtc, tU8 recordNumber) const;
   void  getSnapShotData(tU8 memoryId, tU32 dtc, tU8 recordNumber, tU8& status, tSnapShotDataList& SnapShotDataList)const ;
   void  getSnapShotId(tU8 group, tSnapShotIdList& SnapShotIdList);

   tVoid vProcessOnInit();
   tVoid processSystemEvent(vdl_teDiaglogSystemEvent systemEvent);
   tVoid vProcessExternalAgeingCounter(tU8 AgeingCounter);
   tBool processClearRequest(tU8  u8MemoryId, tU32 u32DtcMask);
   tS8 vProcessReadDTCPriority(tReadReportListDM1& DM1List);
   tVoid vProcessReadRequest(tU8&                       u8StatusAvailabilityMask,
                             tReadReportListArray&      roReadResult,
                             tU8 const                  u8MemoryId,
                             tU8 const&                 u8StatusMask,
                             tU32 const&                u32ITCMask,
                             vdl_teDiaglogOptions const&  eOption);
   tVoid vProcessReadNumberOfDtcByStatusMask(  tU8&          u8StatusAvailabilityMask,
                                               tU32&         u32NumberOfDTC,
                                               tU8 const     u8MemoryId,
                                               tU8 const     u8StatusMask) ;

   tVoid vProcessReadLastConfirmedDTC(tU8&          u8StatusAvailabilityMask,
                                      tReadReportListArray&      roReadResult,
                                      tU8 const                  u8MemoryId) const;

   tVoid vProcessReadSupportedDTCs(tU8&                       u8StatusAvailabilityMask,
                                   tReadReportListArray&      roReadResult,
                                   tU8 const                  u8MemoryId);

   bool bProcessTestReport(tU16 u16IUC, vdl_teDiaglogReportMsg eStatus);  // old interface
   bool bProcessTestReport(vdl_tsDiaglogTestResult oTestResult);          // new interface
   bool bProcessControlCommand(vdl_teDiaglogControlMsg eControlCmd, tDTCListArray const& oDTCList);
   tBool bProcessSetToDefault();

   tBool bEventStep(vdl_teDiaglogEventStep enEventStep, vdl_tclReportRecord* pReportRecord = NULL) const;
   bool bRegisterForEvent(vdl_tclPluginBaseClass* pCallbackClass);
   bool bUnRegisterForEvent(vdl_tclPluginBaseClass* pCallbackClass);
   void vSendUpdateStatusToAll(tITCVector& ITCs) const;
   void vSendUpdateStatusToRequested(tServiceUpdateMap updateMap)const;
   vdl_tclReportRecord* pGetReportRecord(tU8 u8MemoryId, tU16 u16ITC);

   void vCreateMemorys();
   void vDestroyMemorys();
   void vAgeingCompleted(vdl_tclReportRecord* pReportRecord)const;
   void vTraceReports(tU8 u8Memory);
   bool bCheckLoadStatus();
   tU8 getDtcStatus(tU8 aGroup, tU32 aDTC) const;
   vdl_tclReportRecord const* getMostRecentReportRecordByDTC(tU8 MemoryId, tU32 u32DTC)const;

   void getItcInformation(tU8 MemoryId, tU16 ITC,vdl_tsDiaglogItcInformation& itcInformation);

   void LockMemorySemaphore() const;
   void FreeMemorySemaphore() const;
   tU8 getOccuranceCounterByDTC(tU8 MemoryId, tU32 u32DTC)const;

private:
   // operations
   static int g_iMemoryFactoryTableSize();
   tU8 bGetMemoryPosition(tU8 MemoryId) const;

   vdl_tclReportMemory* getReportMemory(tU8 memoryId) const;
   bool processControlCommand(vdl_teDiaglogControlMsg eControlCmd, tDTCListArray const& oDTCList);
   void copyRecordToPlugin(vdl_tsDiaglogPlugInReport& repordRecord, const vdl_tclReportRecord* const pReportRecord)const;

   // attributes
   vdl_tclProtocolConverter m_oProtocolConverter; // to convert e.g. UDS, GMLAN to internal DIAGLOG Format

   // Changed by eva2hi (Evers) for PSARCC21-3952
   // This is a dirty temporary workaround for PSA project. It is not pretty and I am not proud of it, 
   // but currently it is the only way to get access to the memory and report records from a plugin.
   // What we actually need is a interface available to plugins to get (at least) read access to the
   // internal memory data. Because the information available to plugins is currently very limited and
   // does not allow for any more complex logic. Major refactoring of diaglog is part of the core diag
   // backlog and refactoring the plugin concept should be a major part of it.
   friend class vdl_tclDTCTriggerBase;
};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master

