/*!
* \file       vd_diaglog_macros.h
*
* \brief      Generic macro definitions
*
* \details    Generic macro definitions
*
* \component  Diaglog
*
* \ingroup    DiaglogFramework
*
* \copyright  (c) 2012-2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef __VD_DIAGLOG_INCLUDEGUARD_MACROS__
#define __VD_DIAGLOG_INCLUDEGUARD_MACROS__


#define DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(class)                                           \
protected:                                                                                         \
   static class* mpInstance;                                                                       \
                                                                                                   \
public:                                                                                            \
   static class* getInstance ( void );                                                             \
   static void deleteInstance ( void )

//-------------------------------------------------------------------------------------------------

#define DIA_IMPL_SINGLETON(className)                                                              \
className*                                                                                         \
className::mpInstance = 0;                                                                         \
                                                                                                   \
className*                                                                                         \
className::getInstance ( void )                                                                    \
{                                                                                                  \
   if ( !mpInstance )                                                                              \
   {                                                                                               \
      mpInstance = new className;                                                                  \
   }                                                                                               \
                                                                                                   \
   return mpInstance;                                                                              \
}                                                                                                  \
                                                                                                   \
void                                                                                               \
className::deleteInstance ( void )                                                                 \
{                                                                                                  \
   if ( mpInstance )                                                                               \
   {                                                                                               \
      delete mpInstance;                                                                           \
      mpInstance = 0;                                                                              \
   }                                                                                               \
}
#endif /*__VD_DIAGLOG_INCLUDEGUARD_MACROS__*/