//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_itc_definition_common.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: Internal Error code ranges
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 11.09.14  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_common
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_common


/*********************************************************************/
/*********************************************************************/
/*                  Memory Defines (Bitfield)                        */
/*********************************************************************/
/*********************************************************************/
#define   DIAGLOG_MEMORY_CUSTOMER   0x01
#define   DIAGLOG_MEMORY_BOSCH      0x02
#define   DIAGLOG_MEMORY_UNUSED_04  0x04
#define   DIAGLOG_MEMORY_UNUSED_08  0x08
#define   DIAGLOG_MEMORY_UNUSED_10  0x10
#define   DIAGLOG_MEMORY_UNUSED_20  0x20
#define   DIAGLOG_MEMORY_UNUSED_40  0x40
#define   DIAGLOG_MEMORY_UNUSED_80  0x80
#define   DIAGLOG_MEMORY_ALL        0xFF

/*********************************************************************/
/*********************************************************************/
/*                       ITC Defines                                 */
/*********************************************************************/
/*********************************************************************/
//Internal ITC for TML testing only
#define ITC_TML_TEST1                                0x9000
#define ITC_TML_TEST2                                0x9001
#define ITC_TML_TEST3                                0x9002
#define ITC_TML_TEST4                                0x9003

// OPTICALDISC
#define ITC_OPTICALDISC_START                    0x0100          
#define ITC_OPTICALDISC_COMUNICATION_TIMEOUT          0x0100 // commuication to Optical Disc Drive lost             
#define ITC_OPTICALDISC_COMUNICATION_ERROR            0x0101 // communication checksum error                    
#define ITC_OPTICALDISC_DEVICE_ERROR                  0x0102 // disc drive internal Error
#define ITC_OPTICALDISC_READ_ERROR                    0x0103 // disc read error (TOC, Data ...)
#define ITC_OPTICALDISC_DSP_ERROR                     0x0104 // Digital Signal Processor of Optical Disc Drive failed
#define ITC_OPTICALDISC_LOAD_ERROR                    0x0105 // Disc Load Error (Insert/Eject)   
#define ITC_OPTICALDISC_DISC_DEFECT                   0x0106 // Disc could not be read
#define ITC_OPTICALDISC_EJCET_ERROR                   0x0107 // Disc Load Error Eject failed  
#define ITC_OPTICALDISC_INSERT_ERROR                  0x0108 // Disc Load Error insert failed   
#define ITC_OPTICALDISC_END                      0x01ff

// Keyboard
#define ITC_KBD_START                     0x0200
#define ITC_KBD_END                       0x02ff

// Dimming
#define ITC_DIMMING_START                 0x0300
#define ITC_DIMMING_END                   0x03ff

// Phone
#define ITC_PHONE_START                   0x0400
#define ITC_PHONE_END                     0x04ff

// Audio
#define ITC_AUDIO_START                  0x0500
#define ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_GND            0x0500 
#define ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_VSS            0x0501 
#define ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_ACROSS         0x0502
#define ITC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED          0x0503 
#define ITC_AUDIO_TWEETER_LF_CIRCUIT_INTERRUPTED      0x0504
#define ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_GND            0x0510 
#define ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_VSS            0x0511 
#define ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_ACROSS         0x0512
#define ITC_AUDIO_SPK_RF_CIRCUIT_INTERRUPTED          0x0513 
#define ITC_AUDIO_TWEETER_RF_CIRCUIT_INTERRUPTED      0x0514
#define ITC_AUDIO_SPK_LR_CIRCUIT_SHORT_GND            0x0520 
#define ITC_AUDIO_SPK_LR_CIRCUIT_SHORT_VSS            0x0521 
#define ITC_AUDIO_SPK_LR_CIRCUIT_SHORT_ACROSS         0x0522
#define ITC_AUDIO_SPK_LR_CIRCUIT_INTERRUPTED          0x0523 
#define ITC_AUDIO_TWEETER_LR_CIRCUIT_INTERRUPTED      0x0524
#define ITC_AUDIO_SPK_RR_CIRCUIT_SHORT_GND            0x0530 
#define ITC_AUDIO_SPK_RR_CIRCUIT_SHORT_VSS            0x0531 
#define ITC_AUDIO_SPK_RR_CIRCUIT_SHORT_ACROSS         0x0532
#define ITC_AUDIO_SPK_RR_CIRCUIT_INTERRUPTED          0x0533 
#define ITC_AUDIO_TWEETER_RR_CIRCUIT_INTERRUPTED      0x0534
#define ITC_AUDIO_CENTER_CIRCUIT_SHORT_GND            0x0540 
#define ITC_AUDIO_CENTER_CIRCUIT_SHORT_VSS            0x0541 
#define ITC_AUDIO_CENTER_CIRCUIT_SHORT_ACROSS         0x0542
#define ITC_AUDIO_CENTER_CIRCUIT_INTERRUPTED          0x0543 
#define ITC_AUDIO_TWEETER_CENTER_CIRCUIT_INTERRUPTED  0x0544
#define ITC_AUDIO_SUBWOOFER_CIRCUIT_SHORT_GND         0x0550 
#define ITC_AUDIO_SUBWOOFER_CIRCUIT_SHORT_VSS         0x0551 
#define ITC_AUDIO_SUBWOOFER_CIRCUIT_SHORT_ACROSS      0x0552
#define ITC_AUDIO_SUBWOOFER_CIRCUIT_INTERRUPTED       0x0553 

#define ITC_AUDIO_END                     0x05ff

// Microphone 
#define ITC_MIC_START                     0x0600
#define ITC_MIC1_OPEN                              0x0600
#define ITC_MIC1_SHORT_GND                         0x0601   
#define ITC_MIC1_SHORT_BAT                         0x0602  
#define ITC_MIC1_BURNING                           0x0603
#define ITC_MIC1_SYSTEM_FAILURE                    0x0604

#define ITC_MIC2_OPEN                              0x0610  
#define ITC_MIC2_SHORT_GND                         0x0611 
#define ITC_MIC2_SHORT_BAT                         0x0612
#define ITC_MIC2_BURNING                           0x0613
#define ITC_MIC2_SYSTEM_FAILURE                    0x0614
// active Noice Cancellation
#define ITC_MIC_ANC1_OPEN                          0x0620  
#define ITC_MIC_ANC1_SHORT_GND                     0x0621 
#define ITC_MIC_ANC1_SHORT_BAT                     0x0622
#define ITC_MIC_ANC1_BURNING                       0x0623
#define ITC_MIC_ANC1_SYSTEM_FAILURE                0x0624

#define ITC_MIC_ANC2_OPEN                          0x0630  
#define ITC_MIC_ANC2_SHORT_GND                     0x0631 
#define ITC_MIC_ANC2_SHORT_BAT                     0x0632
#define ITC_MIC_ANC2_BURNING                       0x0633
#define ITC_MIC_ANC2_SYSTEM_FAILURE                0x0634

#define ITC_MIC_ANC3_OPEN                          0x0640  
#define ITC_MIC_ANC3_SHORT_GND                     0x0641 
#define ITC_MIC_ANC3_SHORT_BAT                     0x0642
#define ITC_MIC_ANC3_BURNING                       0x0643
#define ITC_MIC_ANC3_SYSTEM_FAILURE                0x0644
#define ITC_MIC_END                       0x06ff

// Heatcontrol / Thermalmanagment
#define ITC_HEATCTRL_START                0x0700
#define ITC_HEATCONTROL_CD_TEMP_HIGH                  0x0700 
#define ITC_HEATCONTROL_CD_CRITICAL_TEMP_HIGH         0x0701
#define ITC_HEATCONTROL_DVD_TEMP_HIGH                 0x0702
#define ITC_HEATCONTROL_DVD_CRITICAL_TEMP_HIGH        0x0703
#define ITC_HEATCONTROL_SYSTEM_TEMP_HIGH              0x0704
#define ITC_HEATCONTROL_SYSTEM_CRITICAL_TEMP_HIGH     0x0705
#define ITC_HEATCONTROL_SYSTEM_TEMP_LOW               0x0706
#define ITC_HEATCONTROL_SYSTEM_CRITICAL_TEMP_LOW      0x0707
#define ITC_HEATCONTROL_DISPLAY_TEMP_HIGH             0x0708
#define ITC_HEATCONTROL_DISPLAY_CRITICAL_TEMP_HIGH    0x0709
#define ITC_HEATCONTROL_DISPLAY_TEMP_LOW              0x070a
#define ITC_HEATCONTROL_DISPLAY_CRITICAL_TEMP_LOW     0x070b
#define ITC_HEATCONTROL_AMPLIFIER_TEMP_HIGH           0x070c
#define ITC_HEATCONTROL_AMPLIFIER_CRITICAL_TEMP_HIGH  0x070d 

#define ITC_HEATCTRL_FAN_OPEN                         0x07f0
#define ITC_HEATCTRL_FAN_OVERCURRENT                  0x07f1
/* Story 1533823 - Retain DTC 0x11E0EC ECU Fan definition */
#define ITC_HEATCTRL_FAN_SYSTEM_FAILURE               0x07f2
#define ITC_HEATCTRL_END                  0x07ff

// Sensor
#define ITC_SENSOR_START                  0x0800
#define ITC_SENSOR_GPS_ANTENNA_OPEN                0x0801 
#define ITC_SENSOR_GPS_ANTENNA_SHORT_GND           0x0802 
#define ITC_SENSOR_GPS_ANTENNA_SHORT_BAT           0x0803 
#define ITC_SENSOR_GPS_ANTENNA_BURNING             0x0804 
#define ITC_SENSOR_GPS_ANTENNA_SHORT               0x0805
#define ITC_SENSOR_GPS_ANTENNA_OPEN_TO_AMPLIFIER   0x0806 
#define ITC_SENSOR_GYROSCOPE_ERROR                 0x0810 
#define ITC_SENSOR_GYROSCOPE_SYSTEM_FAILURE        0x0811 
#define ITC_SENSOR_ODOMETER_NO_INFO                0x0820 
#define ITC_SENSOR_ODOMETER_ERROR                  0x0821 
#define ITC_SENSOR_ODOMETER_INVALID                0x0822 
#define ITC_SENSOR_GPS_FRONT_END_ERROR             0x0830 
#define ITC_SENSOR_GPS_NO_INFO                     0x0831 
#define ITC_SENSOR_GPS_MODULE_SYSTEM_FAILURE       0x0832 
#define ITC_SENSOR_END                    0x08ff

// SPM / LCM
#define ITC_SPM_START                     0x0900
#define ITC_SPM_VOLTAGE_BELOW_THRESHOLD            0x0900
#define ITC_SPM_VOLTAGE_ABOVE_THRESHOLD            0x0901
#define ITC_SPM_VOLTAGE_CRITICAL_BELOW_THRESHOLD   0x0902
#define ITC_SPM_VOLTAGE_CRITICAL_ABOVE_THRESHOLD   0x0903
#define ITC_SPM_END                       0x09ff


// Diagnosis
#define ITC_DIAG_START                    0x0b00
#define ITC_DIAG_CAL_INCOMPLETE              0x0b01
#define ITC_DIAG_CONFIG_INCOMPLETE           0x0b02
#define ITC_DIAG_FAIL_EVENT_NOT_HISTORIZED   0x0b03
#define ITC_DIAG_CONFIG_INVALID              0x0b04
#define ITC_DIAG_CUSTOMER1_CONFIG_INVALID    0x0b04
#define ITC_DIAG_CUSTOMER2_CONFIG_INVALID    0x0b05
#define ITC_DIAG_END                      0x0bff

// Download
#define ITC_DOWNLOAD_START                0x0c00
#define ITC_DOWNLOAD_CRC_FAILED               0x0c00
#define ITC_DOWNLOAD_EEPROM_FAILED            0x0c01
#define ITC_DOWNLOAD_END                  0x0cff

// CSM
#define ITC_CSM_START                     0x0d00
#define ITC_CSM_COMM_BUS_HIGH_OFF            0x0d00      
#define ITC_CSM_COMM_BUS_MID_OFF             0x0d01
#define ITC_CSM_COMM_BUS_LOW_OFF             0x0d02
#define ITC_CSM_BUS_HIGH_NET_ERROR           0x0d03      
#define ITC_CSM_BUS_MID_NET_ERROR            0x0d04
#define ITC_CSM_BUS_LOW_NET_ERROR            0x0d05
#define ITC_CSM_LCW_BCM                      0x0d10      
#define ITC_CSM_LCW_EBCM                     0x0d11   
#define ITC_CSM_LCW_SAS                      0x0d12      
#define ITC_CSM_LCW_EPS                      0x0d13      
#define ITC_CSM_LCW_ECM_PCM                  0x0d14   
#define ITC_CSM_LCW_TCM                      0x0d15  
#define ITC_CSM_LCW_RADIO                    0x0d16 
#define ITC_CSM_LCW_AAS                      0x0d17
#define ITC_CSM_LCW_IPC                      0x0d18 
#define ITC_CSM_LCW_CCM                      0x0d19 
#define ITC_CSM_LCW_AMP                      0x0d1A 
#define ITC_CSM_LCW_DAB                      0x0d1B
#define ITC_CSM_LCW_RCM                      0x0d1C 
#define ITC_CSM_LCW_ICS                      0x0d1D 
#define ITC_CSM_LCW_DIM                      0x0d1E 
#define ITC_CSM_LCW_DSM                      0x0d1F 
#define ITC_CSM_LCW_RSA                      0x0d20 
#define ITC_CSM_LCW_PDIMM                    0x0d21 
#define ITC_CSM_LCW_AOS                      0x0d22 
#define ITC_CSM_LCW_UPA                      0x0d23 
#define ITC_CSM_LCW_CHM                      0x0d24 
#define ITC_CSM_LCW_BSI                      0x0d25 
#define ITC_CSM_LCW_CDC                      0x0d26
#define ITC_CSM_LCW_CLIMATE                  0x0d27 
#define ITC_CSM_LCW_DISPLAY                  0x0d28
#define ITC_CSM_LCW_EMS                      0x0d29 
#define ITC_CSM_LCW_ESC                      0x0d2a 
#define ITC_CSM_LCW_ABM                      0x0d2b 
#define ITC_CSM_LCW_TCU                      0x0d2c
#define ITC_CSM_LCW_EPB                      0x0d2d
#define ITC_CSM_LCW_AFS                      0x0d2e
#define ITC_CSM_LCW_HVAC                     0x0d2f
#define ITC_CSM_LCW_PEPS                     0x0d30
#define ITC_CSM_LCW_TPMS                     0x0d31
#define ITC_CSM_LCW_HU                       0x0d32
#define ITC_CSM_LCW_ICM                      0x0d33
#define ITC_CSM_LCW_SEAT                     0x0d34
#define ITC_CSM_LCW_RM                       0x0d35
#define ITC_CSM_LCW_VRR                      0x0d36
#define ITC_CSM_LCW_GW                       0x0d37
#define ITC_CSM_LCW_AVM                      0x0d38
#define ITC_CSM_END                       0x0dff



// Security
#define ITC_SECURITY_START                0x0e00
#define ITC_SECURITY_VIN_NO_PROGRAM          0x0e00      
#define ITC_SECURITY_PRIVATE_KEY_DAMAGED     0x0e01    
#define ITC_SECURITY_VIN_INCORRECT           0x0e02   
#define ITC_SECURITY_DEVICE_LOCKED           0x0e03  
#define ITC_SECURITY_END                  0x0eff

//#define ITC_xxx_START                     0x0f00
//#define ITC_xxx_END                       0x0fff

// MOST
#define ITC_MOST_START                    0x1000
#define ITC_MOST_OPEN                        0x1000
#define ITC_MOST_SHORT_GND                   0x1001
#define ITC_MOST_SHORT_BAT                   0x1002
#define ITC_MOST_BURNING                     0x1003
#define ITC_MOST_SYSTEM_FAILURE              0x1004
#define ITC_MOST_PERFORMANCE_FAILURE         0x1005
#define ITC_MOST_END                      0x10ff

// DAB Tuner
#define ITC_DAB_TUNER_START               0x1100
#define ITC_DAB_TUNER_ANT1_OPEN                 0x1100
#define ITC_DAB_TUNER_ANT1_SHORT_GND            0x1101
#define ITC_DAB_TUNER_ANT1_SHORT_BAT            0x1102
#define ITC_DAB_TUNER_ANT1_BURNING              0x1103
#define ITC_DAB_TUNER_ANT1_SYSTEM_FAILURE       0x1104
#define ITC_DAB_TUNER_ANT1_SHORT                0x1105
#define ITC_DAB_TUNER_ANT1_OPEN_TO_AMPLIFIER    0x1106
#define ITC_DAB_TUNER_ANT2_OPEN                 0x1110
#define ITC_DAB_TUNER_ANT2_SHORT_GND            0x1111
#define ITC_DAB_TUNER_ANT2_SHORT_BAT            0x1112
#define ITC_DAB_TUNER_ANT2_BURNING              0x1113
#define ITC_DAB_TUNER_ANT2_SYSTEM_FAILURE       0x1114
#define ITC_DAB_TUNER_ANT2_SHORT                0x1115
#define ITC_DAB_TUNER_ANT2_OPEN_TO_AMPLIFIER    0x1116
#define ITC_DAB_TUNER_SYSTEM_FAILURE            0x1120
#define ITC_DAB_TUNER_INT_COMM_FAILURE          0x1121
#define ITC_DAB_TUNER_END                 0x11ff

// Video / RVC
#define ITC_VIDEO_START                   0x1200
#define ITC_VIDEO_GENERAL_ELECTRIC_FAILURE   0x1200
#define ITC_VIDEO_NO_NTSC                    0x1201
#define ITC_VIDEO_NO_SIGNAL                  0x1202
#define ITC_VIDEO_AVM_NO_SIGNAL              0x1203

#define ITC_VIDEO_RVC_OPEN                   0x1210
#define ITC_VIDEO_RVC_SHORT_GND              0x1211
#define ITC_VIDEO_RVC_SHORT_BAT              0x1212
#define ITC_VIDEO_END                     0x12ff

// Display
#define ITC_DISPLAY_START                 0x1300
#define ITC_DISPLAY_NO_SUBTYPE_INFORMATION   0x1300
#define ITC_DISPLAY_GENERAL_MEMORY_FAILURE   0x1301
#define ITC_DISPLAY_ELECTRONIC_FAILURE       0x1302
#define ITC_DISPLAY_COMMUNICATION_FAILURE    0x1303
#define ITC_DISPLAY_INCORRECT_COMPONENT      0x1304
#define ITC_DISPLAY_SHORT_GND                0x1305
#define ITC_DISPLAY_SHORT_BAT                0x1306
#define ITC_DISPLAY_LOST_COMMUNICATON        0x1307
#define ITC_DISPLAY_SYSTEM_FAILURE           0x1308
#define ITC_DISPLAY_END                   0x13ff

// Amplifier
#define ITC_AMPLIFIER_START               0x1400
#define ITC_AMPLIFIER_SYSTEM_FAILURE                     0x1400

#define ITC_AMPLIFIER_CHANNEL_FRONT_LEFT_FAILURE         0x1410
#define ITC_AMPLIFIER_CHANNEL_FRONT_LEFT_OPEN            0x1411
#define ITC_AMPLIFIER_CHANNEL_FRONT_LEFT_SHORT_GND       0x1412
#define ITC_AMPLIFIER_CHANNEL_FRONT_LEFT_SHORT_BAT       0x1413

#define ITC_AMPLIFIER_CHANNEL_FRONT_RIGHT_FAILURE        0x1420
#define ITC_AMPLIFIER_CHANNEL_FRONT_RIGHT_OPEN           0x1421
#define ITC_AMPLIFIER_CHANNEL_FRONT_RIGHT_SHORT_GND      0x1422
#define ITC_AMPLIFIER_CHANNEL_FRONT_RIGHT_SHORT_BAT      0x1423

#define ITC_AMPLIFIER_CHANNEL_CENTER1_FAILURE            0x1430
#define ITC_AMPLIFIER_CHANNEL_CENTER1_OPEN               0x1431
#define ITC_AMPLIFIER_CHANNEL_CENTER1_SHORT_GND          0x1432
#define ITC_AMPLIFIER_CHANNEL_CENTER1_SHORT_BAT          0x1433

#define ITC_AMPLIFIER_CHANNEL_CENTER2_FAILURE            0x1440
#define ITC_AMPLIFIER_CHANNEL_CENTER2_OPEN               0x1441
#define ITC_AMPLIFIER_CHANNEL_CENTER2_SHORT_GND          0x1442
#define ITC_AMPLIFIER_CHANNEL_CENTER2_SHORT_BAT          0x1443

#define ITC_AMPLIFIER_CHANNEL_LEFT_FAILURE               0x1450
#define ITC_AMPLIFIER_CHANNEL_LEFT_OPEN                  0x1451
#define ITC_AMPLIFIER_CHANNEL_LEFT_SHORT_GND             0x1452
#define ITC_AMPLIFIER_CHANNEL_LEFT_SHORT_BAT             0x1453

#define ITC_AMPLIFIER_CHANNEL_RIGHT_FAILURE              0x1460
#define ITC_AMPLIFIER_CHANNEL_RIGHT_OPEN                 0x1461
#define ITC_AMPLIFIER_CHANNEL_RIGHT_SHORT_GND            0x1462
#define ITC_AMPLIFIER_CHANNEL_RIGHT_SHORT_BAT            0x1463

#define ITC_AMPLIFIER_CHANNEL_SUB1_FAILURE               0x1470
#define ITC_AMPLIFIER_CHANNEL_SUB1_OPEN                  0x1471
#define ITC_AMPLIFIER_CHANNEL_SUB1_SHORT_GND             0x1472
#define ITC_AMPLIFIER_CHANNEL_SUB1_SHORT_BAT             0x1473

#define ITC_AMPLIFIER_CHANNEL_SUB2_FAILURE               0x1480
#define ITC_AMPLIFIER_CHANNEL_SUB2_OPEN                  0x1481
#define ITC_AMPLIFIER_CHANNEL_SUB2_SHORT_GND             0x1482
#define ITC_AMPLIFIER_CHANNEL_SUB2_SHORT_BAT             0x1483

#define ITC_AMPLIFIER_ON_OPEN                            0x1491
#define ITC_AMPLIFIER_ON_SHORT_GND                       0x1492
#define ITC_AMPLIFIER_ON_SHORT_BAT                       0x1493

#define ITC_AMPLIFIER_END                 0x14ff

// Auxillary
#define ITC_AUX_START                     0x1500
#define ITC_AUX_INPUT_1_SHORT_GND            0x1500
#define ITC_AUX_INPUT_1_SHORT_BAT            0x1501
#define ITC_AUX_INPUT_1_OPEN                 0x1502
#define ITC_AUX_INPUT_2_SHORT_GND            0x1510
#define ITC_AUX_INPUT_2_SHORT_BAT            0x1511
#define ITC_AUX_INPUT_2_OPEN                 0x1512
#define ITC_AUX_END                       0x15ff

// XM Tuner
#define ITC_XM_TUNER_START                0x1600
#define ITC_XM_TUNER_ANT1_OPEN               0x1600
#define ITC_XM_TUNER_ANT1_SHORT_GND          0x1601
#define ITC_XM_TUNER_ANT1_SHORT_BAT          0x1602
#define ITC_XM_TUNER_ANT1_BURNING            0x1603
#define ITC_XM_TUNER_ANT1_SYSTEM_FAILURE     0x1604
#define ITC_XM_TUNER_ANT1_SHORT              0x1605
#define ITC_XM_TUNER_ANT1_OPEN_TO_AMPLIFIER  0x1606
#define ITC_XM_TUNER_ANT2_OPEN               0x1610
#define ITC_XM_TUNER_ANT2_SHORT_GND          0x1611
#define ITC_XM_TUNER_ANT1_SHORT_BAT          0x1602
#define ITC_XM_TUNER_ANT2_BURNING            0x1613
#define ITC_XM_TUNER_ANT2_SYSTEM_FAILURE     0x1614
#define ITC_XM_TUNER_ANT2_SHORT              0x1615
#define ITC_XM_TUNER_ANT2_OPEN_TO_AMPLIFIER  0x1616
#define ITC_XM_TUNER_SYSTEM_FAILURE          0x1620
#define ITC_XM_TUNER_INT_COMM_FAILURE        0x1621
#define ITC_XM_TUNER_END                  0x16ff

// AMFM Tuner
#define ITC_AMFM_TUNER_START              0x1700
#define ITC_AMFM_TUNER_ANT1_OPEN                0x1700
#define ITC_AMFM_TUNER_ANT1_SHORT_GND           0x1701
#define ITC_AMFM_TUNER_ANT1_SHORT_BAT           0x1702
#define ITC_AMFM_TUNER_ANT1_BURNING             0x1703
#define ITC_AMFM_TUNER_ANT1_SYSTEM_FAILURE      0x1704
#define ITC_AMFM_TUNER_ANT1_SHORT               0x1705
#define ITC_AMFM_TUNER_ANT1_OPEN_TO_AMPLIFIER   0x1706
#define ITC_AMFM_TUNER_ANT2_OPEN                0x1710
#define ITC_AMFM_TUNER_ANT2_SHORT_GND           0x1711
#define ITC_AMFM_TUNER_ANT2_SHORT_BAT           0x1712
#define ITC_AMFM_TUNER_ANT2_BURNING             0x1713
#define ITC_AMFM_TUNER_ANT2_SYSTEM_FAILURE      0x1714
#define ITC_AMFM_TUNER_ANT2_SHORT               0x1715
#define ITC_AMFM_TUNER_ANT2_OPEN_TO_AMPLIFIER   0x1716
#define ITC_AMFM_TUNER_ANT3_OPEN                0x1720
#define ITC_AMFM_TUNER_ANT3_SHORT_GND           0x1721
#define ITC_AMFM_TUNER_ANT3_SHORT_BAT           0x1722
#define ITC_AMFM_TUNER_ANT3_BURNING             0x1723
#define ITC_AMFM_TUNER_ANT3_SYSTEM_FAILURE      0x1724
#define ITC_AMFM_TUNER_ANT3_SHORT               0x1725
#define ITC_AMFM_TUNER_ANT3_OPEN_TO_AMPLIFIER   0x1726
#define ITC_AMFM_TUNER1_SYSTEM_FAILURE          0x1730
#define ITC_AMFM_TUNER2_SYSTEM_FAILURE          0x1731
#define ITC_AMFM_TUNER3_SYSTEM_FAILURE          0x1732
#define ITC_AMFM_TUNER_INT_COMM_FAILURE         0x1733
#define ITC_AMFM_TUNER_END                0x17ff

// Internet Application
#define ITC_INET_APP_START                0x1800
#define ITC_INET_APP_SYSTEM_FAILURE          0x1800
#define ITC_INET_APP_END                  0x18ff

// Bluetooth
#define ITC_BLUETOOTH_START                0x1900
#define ITC_BLUETOOTH_SYSTEM_FAILURE          0x1900
#define ITC_BLUETOOTH_END                  0x19ff

// ECU General
#define ITC_ECU_START                     0x1a00
#define ITC_ECU_INTERNAL_FAILURE             0x1a00
#define ITC_ECU_ROM_DEFECT                   0x1a01
#define ITC_ECU_EEPROM_DEFECT                0x1a02
#define ITC_ECU_BLUETOOTH_DEFECT             0x1a03
#define ITC_ECU_WIFI_DEFECT                  0x1a04
#define ITC_ECU_END                       0x1aff

// TMC Tuner
#define ITC_TMC_TUNER_START                0x1B00
#define ITC_TMC_TUNER_ANT1_OPEN               0x1B00
#define ITC_TMC_TUNER_ANT1_SHORT_GND          0x1B01
#define ITC_TMC_TUNER_ANT1_SHORT_BAT          0x1B02
#define ITC_TMC_TUNER_ANT1_BURNING            0x1B03
#define ITC_TMC_TUNER_ANT1_SYSTEM_FAILURE     0x1B04
#define ITC_TMC_TUNER_ANT1_SHORT              0x1B05
#define ITC_TMC_TUNER_ANT1_OPEN_TO_AMPLIFIER  0x1B06
#define ITC_TMC_TUNER_ANT2_OPEN               0x1B10
#define ITC_TMC_TUNER_ANT2_SHORT_GND          0x1B11
#define ITC_TMC_TUNER_ANT1_SHORT_BAT          0x1B02
#define ITC_TMC_TUNER_ANT2_BURNING            0x1B13
#define ITC_TMC_TUNER_ANT2_SYSTEM_FAILURE     0x1B14
#define ITC_TMC_TUNER_ANT2_SHORT              0x1B15
#define ITC_TMC_TUNER_ANT2_OPEN_TO_AMPLIFIER  0x1B16
#define ITC_TMC_TUNER_SYSTEM_FAILURE          0x1B20
#define ITC_TMC_TUNER_INT_COMM_FAILURE        0x1B21
#define ITC_TMC_TUNER_END                  0x1Bff

//INC
#define ITC_INC_START                     0x1c00
#define ITC_INC_SYSTEM_FAILURE               0x1c00
#define ITC_INC_END                       0x1cff

//TLIN
#define ITC_TLIN_START                     0x1d00
#define ITC_TLIN_SYSTEM_FAILURE               0x1d00
#define ITC_TLIN_COMMUNICATION_FAILURE        0x1d01
#define ITC_TLIN_ELECTRONIC_FAILURE           0x1d02
#define ITC_TLIN_INCORRECT_COMPONENT          0x1d03
#define ITC_TLIN_LCW_XY                       0x1d10
#define ITC_TLIN_LCW_LVM                      0x1d11
#define ITC_TLIN_LCW_VBM                      0x1d12
#define ITC_TLIN_REVERSE_GEAR_INVALID         0x1d20
#define ITC_TLIN_END                       0x1dff

//LIN
#define ITC_LIN_START                     0x1e00
#define ITC_LIN_LCW_JOYSTICK                 0x1e00  
#define ITC_LIN_LCW_FRONTPANNEL              0x1e01  
#define ITC_LIN_LCW_RSE_PANNEL               0x1e02 
#define ITC_LIN_LCW_SWC_PANNEL               0x1e03 
#define ITC_LIN_JOYSTICK_ERROR               0x1e10  
#define ITC_LIN_FRONTPANNEL_ERROR            0x1e11  
#define ITC_LIN_RSE_PANNEL_ERROR             0x1e12 
#define ITC_LIN_SWC_PANNEL_ERROR             0x1e13 
#define ITC_LIN_END                       0x1eff

// USB1
#define ITC_USB1_START                   0x1f00
/* Story 1533823 - to retain DTC 0x10E0EC USB Hub definition */
#define ITC_USB1_OVERCURRENT                    0x1f00   
#define ITC_USB1_HUB_NOT_DETECTED               0x1f01   
#define ITC_USB1_HUB_NUMBER_OF_PORTS_MISMATCH   0x1f02   
#define ITC_USB1_OPEN                           0x1f03
#define ITC_USB1_LINK_DISABLED                  0x1f04
#define ITC_USB1_SPEED_REDUCED                  0x1f05
#define ITC_USB1_DATA_LINE_FAULT                0x1f06
#define ITC_USB1_POWER_SUPPLY_FAULT             0x1f07
#define ITC_USB1_SHORT_GND                      0x1f08
#define ITC_USB1_SHORT_BAT                      0x1f09
#define ITC_USB1_SYSTEM_FAILURE                 0x1f0A
#define ITC_USB1_END                      0x1fff

// USB2
#define ITC_USB2_START                   0x2000
/* Story 1533823 - to retain DTC 0x10E0EC USB Hub definition */
#define ITC_USB2_OVERCURRENT                    0x2000   
#define ITC_USB2_HUB_NOT_DETECTED               0x2001   
#define ITC_USB2_HUB_NUMBER_OF_PORTS_MISMATCH   0x2002   
#define ITC_USB2_OPEN                           0x2003
#define ITC_USB2_LINK_DISABLED                  0x2004
#define ITC_USB2_SPEED_REDUCED                  0x2005
#define ITC_USB2_DATA_LINE_FAULT                0x2006
#define ITC_USB2_POWER_SUPPLY_FAULT             0x2007
#define ITC_USB2_SHORT_GND                      0x2008
#define ITC_USB2_SHORT_BAT                      0x2009
#define ITC_USB2_SYSTEM_FAILURE                 0x200A
#define ITC_USB2_END                      0x20ff

// USB3
#define ITC_USB3_START                   0x2100
/* Story 1533823 - to retain DTC 0x10E0EC USB Hub definition */
#define ITC_USB3_OVERCURRENT                    0x2100   
#define ITC_USB3_HUB_NOT_DETECTED               0x2101   
#define ITC_USB3_HUB_NUMBER_OF_PORTS_MISMATCH   0x2102   
#define ITC_USB3_OPEN                           0x2103
#define ITC_USB3_LINK_DISABLED                  0x2104
#define ITC_USB3_SPEED_REDUCED                  0x2105
#define ITC_USB3_DATA_LINE_FAULT                0x2106
#define ITC_USB3_POWER_SUPPLY_FAULT             0x2107
#define ITC_USB3_SHORT_GND                      0x2108
#define ITC_USB3_SHORT_BAT                      0x2109
#define ITC_USB3_SYSTEM_FAILURE                0x210A
#define ITC_USB3_END                      0x21ff


#define ITC_CAN_START                     0x2200
#define ITC_CAN_SYSTEM_FAILURE               0x2200
#define ITC_CAN_END                       0x22ff

// WIFI
#define ITC_WIFI_START                    0x2300
#define ITC_WIFI_SYSTEM_FAILURE              0x2300
#define ITC_WIFI_END                      0x23ff

// Memory Card
#define ITC_MEMORY_CARD_START             0x2400
#define ITC_MEMORY_CARD_OVERCURRENT          0x2400 
#define ITC_MEMORY_CARD_END               0x24ff

// Memory Card2
#define ITC_MEMORY_CARD2_START             0x2500
#define ITC_MEMORY_CARD2_OVERCURRENT         0x2500  
#define ITC_MEMORY_CARD2_END               0x25ff

// CD-Drive, CD-Changer
#define ITC_CD_CDC_START                   0x2600
#define ITC_CD_LCW_CD_DRIVE                  0x2600   
#define ITC_CD_LCW_CD_CHANGER                0x2601 

#define ITC_CD_DRIVE_ELECTRONIC_FAILURE      0x2610  
#define ITC_CD_DRIVE_OVERTEMP                0x2611   
#define ITC_CD_CDC_END                     0x26ff

// D-TV
#define ITC_DTV_START                      0x2700

#define ITC_DTV_ANT1_OPEN                    0x2700
#define ITC_DTV_ANT1_SHORT_GND               0x2701
#define ITC_DTV_ANT1_SHORT_BAT               0x2702

#define ITC_DTV_ANT2_OPEN                    0x2710
#define ITC_DTV_ANT2_SHORT_GND               0x2711
#define ITC_DTV_ANT2_SHORT_BAT               0x2712

#define ITC_DTV_ANT3_OPEN                    0x2720
#define ITC_DTV_ANT3_SHORT_GND               0x2721
#define ITC_DTV_ANT3_SHORT_BAT               0x2722

#define ITC_DTV_ANT4_OPEN                    0x2730
#define ITC_DTV_ANT4_SHORT_GND               0x2731
#define ITC_DTV_ANT4_SHORT_BAT               0x2732

#define ITC_DTV_END                        0x27ff

// USB4
#define ITC_USB4_START                   0x2800
/* Story 1533823 - to retain DTC 0x10E0EC USB Hub definition */
#define ITC_USB4_OVERCURRENT                    0x2800   
#define ITC_USB4_HUB_NOT_DETECTED               0x2801   
#define ITC_USB4_HUB_NUMBER_OF_PORTS_MISMATCH   0x2802   
#define ITC_USB4_OPEN                           0x2803
#define ITC_USB4_LINK_DISABLED                  0x2804
#define ITC_USB4_SPEED_REDUCED                  0x2805
#define ITC_USB4_DATA_LINE_FAULT                0x2806
#define ITC_USB4_POWER_SUPPLY_FAULT             0x2807
#define ITC_USB4_SHORT_GND                      0x2808
#define ITC_USB4_SHORT_BAT                      0x2809
#define ITC_USB4_SYSTEM_FAILURE                 0x280A
#define ITC_USB4_END                      0x28ff


//#define ITC_xxx_START                     0x??00
//#define ITC_xxx_END                       0x??ff

// Prj Dependend
#define ITC_PRJ_DEPENDEND_START           0x8000
#define ITC_PRJ_DEPENDEND_END             0xDFFF

#define DYNAMICAL_ITC_START_ID            0xE000


/*******************************************************************/
/* !!! DO NOT USE THE FOLLOWING ANY LONGER !!!                     */
/* only for downward compatibility                                 */
/*******************************************************************/
#define ITC_VOICE_MIC1_OPEN                  ITC_MIC1_OPEN           
#define ITC_VOICE_MIC1_SHORT_GND             ITC_MIC1_SHORT_GND         
#define ITC_VOICE_MIC1_SHORT_BAT             ITC_MIC1_SHORT_BAT        
#define ITC_VOICE_MIC1_BURNING               ITC_MIC1_BURNING        
#define ITC_VOICE_MIC1_SYSTEM_FAILURE        ITC_MIC1_SYSTEM_FAILURE 
#define ITC_VOICE_MIC2_OPEN                  ITC_MIC2_OPEN             
#define ITC_VOICE_MIC2_SHORT_GND             ITC_MIC2_SHORT_GND       
#define ITC_VOICE_MIC2_SHORT_BAT             ITC_MIC2_SHORT_BAT      
#define ITC_VOICE_MIC2_BURNING               ITC_MIC2_BURNING        
#define ITC_VOICE_MIC2_SYSTEM_FAILURE        ITC_MIC2_SYSTEM_FAILURE 

#define ITC_STREAMROUTER_MIC1_OPEN           ITC_MIC1_OPEN           
#define ITC_STREAMROUTER_MIC1_SHORT_GND      ITC_MIC1_SHORT_GND         
#define ITC_STREAMROUTER_MIC1_SHORT_BAT      ITC_MIC1_SHORT_BAT        
#define ITC_STREAMROUTER_MIC1_BURNING        ITC_MIC1_BURNING        
#define ITC_STREAMROUTER_MIC1_SYSTEM_FAILURE ITC_MIC1_SYSTEM_FAILURE 
#define ITC_STREAMROUTER_MIC2_OPEN           ITC_MIC2_OPEN             
#define ITC_STREAMROUTER_MIC2_SHORT_GND      ITC_MIC2_SHORT_GND       
#define ITC_STREAMROUTER_MIC2_SHORT_BAT      ITC_MIC2_SHORT_BAT      
#define ITC_STREAMROUTER_MIC2_BURNING        ITC_MIC2_BURNING        
#define ITC_STREAMROUTER_MIC2_SYSTEM_FAILURE ITC_MIC2_SYSTEM_FAILURE 

#define ITC_HEATCTRL_TEMP_LOW                ITC_HEATCONTROL_SYSTEM_TEMP_LOW 
#define ITC_HEATCTRL_TEMP_HIGH               ITC_HEATCONTROL_SYSTEM_TEMP_HIGH



#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition
    #include "../../../diaglog_prj/project/framework/vd_diaglog_itc_definition.h" // switch to prj
#endif


#endif
