//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_freeze_frame_data.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog BaseClass for FreezeFrameData
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 13.05.13  | BSOT Plischke               | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARDvd_diaglog_freeze_frame_data
#define VD_DIAGLOG_INCLUDEGUARDvd_diaglog_freeze_frame_data


// do not touch this
typedef union
{
   tsDiaglogFreezeFrameData Struct;
   tU8                      Array[sizeof(tsDiaglogFreezeFrameData)];
}vdl_tuDiaglogFreezeFrameData;

class vdl_tclFreezeFrameDataBase
{
   public:
      vdl_tclFreezeFrameDataBase() {};
      virtual ~vdl_tclFreezeFrameDataBase() {};

      virtual tVoid vUpdateFreezeFrameData() = 0;

      void vLoadFreezeFrameData(tStreamCIterator& iPos);
      void vSaveFreezeFrameData(tStream& roData) const;
      vdl_tuDiaglogFreezeFrameData uGetFreezeFrameData()const;

   private:
      int iSizeOfFreezeFrameData() const;


   protected:
      vdl_tuDiaglogFreezeFrameData m_uFreezeFrameData;
};



#endif // VD_DIAGLOG_INCLUDEGUARDvd_diaglog_freeze_frame_data
