/************************************************************************
* FILE:         vd_diaglog_blockingmode.h
* PROJECT:      Diag CORE
* SW-COMPONENT: VD_DiagLog
*----------------------------------------------------------------------
*
* DESCRIPTION: DiagLog main application class
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 14.01.13  | BSOT Plischke      | new Diaglog
*************************************************************************/

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_blockingmode
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_blockingmode

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class vdDiagLog_BlockingMode
{
   typedef struct {
      tU32         blockingMask;
      tU32         callbackId;
      tDTCVector   dtcBlockList;
   }tsBlockingConfig;
   typedef std::pair <tU8,tU32> tIdDtcPair;
   typedef std::pair <tU8,tU16> tIdItcPair;
   typedef std::map<tIdDtcPair, tITCVector>                  tDTCBlockingMap;
   typedef std::map<tIdDtcPair, tITCVector>::iterator        tDTCBlockingMapIt;
   typedef std::map<tIdDtcPair, tITCVector>::const_iterator  tDTCBlockingMapCIt;
   typedef std::set<tIdItcPair>                  tITCUpdateSet;
   typedef std::set<tIdItcPair>::iterator        tITCUpdateSetIt;
   typedef std::set<tIdItcPair>::const_iterator  tITCUpdateSetCIt;
   typedef std::map<tIdItcPair, tsBlockingConfig>                  tITCCallbackMap;
   typedef std::map<tIdItcPair, tsBlockingConfig>::iterator        tITCCallbackMapIt;
   typedef std::map<tIdItcPair, tsBlockingConfig>::const_iterator  tITCCallbackMapCIt;


// construction/destruction
public:
   vdDiagLog_BlockingMode(); 
   ~vdDiagLog_BlockingMode();

// operations   
   tU32 u32GetSystemBlockingMode(){return m_u32BlockingMode;}
   tU32 u32GetValidSinceLastSendBlockingMode(){return m_u32ValidSinceLastSendBlockingMode;}

   // that are the calls from outside and differ to the internal ones
   tVoid vSetBlockingMode(tU32 u32Mode){vSetResetBlockingMode(u32Mode,0);};
   tVoid vResetBlockingMode(tU32 u32Mode){vSetResetBlockingMode(0,u32Mode);};
   tVoid vSetResetBlockingMode(tU32 u32ModeSet, tU32 u32ModeReset);
   bool isBlockingModeActive(vdl_tclReportRecord const* pReportRecord,tU32& blockingModeMask)const;
   static tVoid vResetBlockingModeTimerCall(tU32 u32Mode);  // called by Timer functions
   tVoid vSetResetBlockingModeEventUpdate();                // called by Diaglog Main Thread
   void updateBlockingModeAfterPassed(vdl_tclReportRecord const* pReportRecord);
   bool registerBlockModeCallback(tU8 MemoryId, tU16 ITC, tU32 callbackId, tU32 blockingMask, std::vector<tU32> blockDTCList);
   bool unregisterBlockModeCallback(tU8 MemoryId, tU16 ITC);

   // standard functions
   bool bOnInit();
   tVoid vOnClose();


   // variables
   static OSAL_tSemHandle     m_hBlockSem;

private:
// operations   
   void LockSemaphore() const;
   void FreeSemaphore() const;

   bool bStartStartupBlockTimer(tU16 u16Time);
   bool bStartPowerBlockTimer(tU16 u16Time);
   bool bStartPowerRunBlockTimer(tU16 u16Time);
   bool bStartMostBusBlockTimer(tU16 u16Time);
   bool bEndMostBusBlockTimer();
   bool bStartVoltageBlockTimer(tU16 u16Time);
   bool isBlockingModeByMaskActive(vdl_tclReportRecord const* pReportRecord,tU32& blockingModeMask) const;
   bool isBlockingModeByDTCListActive(vdl_tclReportRecord const* pReportRecord,tU32& blockingModeMask) const;
   void addDTCToBlockList(tU8 MemoryId, tU16 requestingITC, tU32 blockDTC) ;
   bool isBlockingModeActive(const tIdItcPair& idItcPair) const;
   void update();

   tVoid changeBlockingMode(tU32 u32ModeSet, tU32 u32ModeReset);
   tVoid setBlockingMode(tU32 u32ModeSet){changeBlockingMode(u32ModeSet, 0);};
   tVoid resetBlockingMode(tU32 u32ModeReset){changeBlockingMode(0,u32ModeReset);};

   static void vBlockStartupTimerHandler(tPVoid /*pvArg*/);   
   static void vBlockPowerCrankTimerHandler(tPVoid /*pvArg*/);  //Blocking after getting out from Crank Mode
   static void vBlockPowerRunTimerHandler(tPVoid /*pvArg*/); //Blocking after getting in Run Mdoe
   static void vBlockMostBusTimerHandler(tPVoid /*pvArg*/);  //U0029 Timer Bloocking Mode
   static void vBlockVoltageTimerHandler(tPVoid /*pvArg*/);  //Blocking Mode after Getting Out from Under/Overvoltage
   static void vBlockUpdateTimerHandler(tPVoid /*pvArg*/);   //Blocking Mode update limit


   tVoid vUpdateAfterBlockingMode();

   // variables
   OSAL_tTimerHandle   m_hStartupBlockTimer;
   OSAL_tTimerHandle   m_hPowerCrankBlockTimer;
   OSAL_tTimerHandle   m_hPowerRunBlockTimer;
   OSAL_tTimerHandle   m_hMostBusBlockTimer;
   OSAL_tTimerHandle   m_hVoltageBlockTimer;
   OSAL_tTimerHandle   m_hBlockUpdateTimer; // this Timer is for overrun protection


   static tU32                m_u32BlockingModeTimerCallAdd;
   static tU32                m_u32BlockingModeTimerCallRemove;
   static bool                m_isBlockingModeUpdateTrigger;

   tU32                       m_u32BlockingMode;
   tU32                       m_u32BlockingModeLast;
   tU32                       m_u32BlockingModeSetSinceLastUpdate;
   tU32                       m_u32BlockingModeGoneSinceLastUpdate;
   tU32                       m_u32ValidSinceLastSendBlockingMode;
   bool                       m_isMostBusTimerRunning;
   tU32                       m_u32BlockingModeCounter;
   bool                       m_isBlockingModeUpdateAllowed;
   bool                       m_isBlockingModeUpdateRequested;

   tDTCBlockingMap m_DTCBlockingMap;
   tITCUpdateSet   m_ITCUpdateSet;
   tITCCallbackMap m_ITCCallbackMap;
}; 

#endif //VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_blockingmode

