/*
 * vd_diaglog_filedir.h
 *
 *  Created on: 28.03.2017
 *      Author: abe6kor
 */

#ifndef _VD_DIAGLOG_FILEDIR_H_
#define _VD_DIAGLOG_FILEDIR_H_

#include <unistd.h>
#include <string>
#include <sys/types.h>
#include <sys/stat.h>

class vdDiaglog_FileDir
{
public:
   vdDiaglog_FileDir ( tCString dirName, mode_t dirMode = S_IRWXU|S_IRWXG);
   virtual ~vdDiaglog_FileDir ( void );

   //! create the directory with the given pathname and the given permissions
   virtual bool createDirIfNotExist ( void );

   //! check if a directory with the given pathname already exists
   virtual bool doesExist ( void ) const;

protected:
   //! name of the directory (full path name)
   std::string mDirName;
   mode_t      mMode;

};

#endif /* _VD_DIAGLOG_FILEDIR_H_ */
