//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_snapshotDataConfiguration.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: SnapShot configuration Data
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 03.05.15  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_snapshotDataConfiguration
#define VD_DIAGLOG_INCLUDEGUARD_snapshotDataConfiguration

#define MAX_DID_PER_RECORD_SUPPORTED   10

typedef struct
{
   tU8   record;
   tU32  DID[MAX_DID_PER_RECORD_SUPPORTED];
}trSnapShotRecordDidMapping;


// pure static 
class vdl_tclSnapShotConfig
{
public:
   vdl_tclSnapShotConfig(){} // constructor
   virtual ~vdl_tclSnapShotConfig(){};

   /* Get Nr Of Valid DID's */
   tU8 getNrOfDIDs(const tU8 record) 
   {
      tU8 size = 0;
      for(int rec=0; rec<iSnapShotRecordDidMappingSize(); rec++)
      {
         if(sRecordDidMapping[rec].record == record)
         {
            for(int i=0;i<MAX_DID_PER_RECORD_SUPPORTED;i++)
            {
               size++;
               if(sRecordDidMapping[rec].DID[i] == 0)
               {
                  break;
               }
            }
            break;
         }// if(sRecordDidMapping[rec].record == record)
      }
      return size;
   }// tU8 getNrOfDIDs(tU8 record)

   /* Get DID by give Pos */
   tU32 getDID(const tU8 record, tU8 pos)
   {
      tU32 DID = 0;
      if(pos >= MAX_DID_PER_RECORD_SUPPORTED)
      {
         // out of range
         NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
         
         for(int rec=0;rec < iSnapShotRecordDidMappingSize();rec++)
         {
            if(sRecordDidMapping[rec].record == record)
            {
               DID = sRecordDidMapping[rec].DID[pos];
               break;
            }
         }
      }
      return DID;
   }

private:
   // operation
   static int iSnapShotRecordDidMappingSize(void);

   // attributes
   static const trSnapShotRecordDidMapping sRecordDidMapping[];
};


#endif