#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedData
#define VD_DIAGLOG_INCLUDEGUARD_ExtendedData


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

namespace VDD
{

//lint -esym(1712, ExtendedDataStruct) 
struct ExtendedDataStruct
{
   ExtendedDataStruct(tU8 aRecNo) : recNo(aRecNo) {}
   tU8   recNo;
   std::vector<tU8> data;
};

typedef std::vector<ExtendedDataStruct> tExtendedFrameList;

class ExtendedData
{
private:
   ExtendedData():xData(0),maxSize(0) {} //lint -esym(1704, VDD::ExtendedData::ExtendedData)  // do not use so made as private

public:
   ExtendedData(tU8 aRecNo, size_t size): xData(aRecNo), maxSize(size) {this->xData.data.assign(maxSize, 0);}
   virtual ~ExtendedData(void) {}
private:
   ExtendedDataStruct xData;
   size_t maxSize;
public:
   virtual void add(ExtendedData*) {throw;}
   virtual void collect() = 0;
   virtual void getFrameList(tExtendedFrameList& aFrames) const;
   virtual void load(tStreamCIterator& iPos);
   virtual void  save(tStream& roData);

   virtual void  clear()=0;
   int getRecNo()	const {return this->xData.recNo;}
   std::vector<tU8> getData() const {return this->xData.data;}
   void setData(std::vector<tU8> const& aData);
};


class ExtendedDataRecord : public ExtendedData
{
public:
   ExtendedDataRecord();
   ExtendedDataRecord(tU8 aRecNo) : ExtendedData(aRecNo, 0) {}
   virtual ~ExtendedDataRecord(void) {}
private:
   std::vector<ExtendedData*> records;
public:
   virtual void add(ExtendedData* ed) {records.push_back(ed);}
   //virtual void collect () {for_each(records.begin(), records.end(),  mem_fun(&ExtendedData::collect));}
   virtual void collect () {}
   virtual void getFrameList(tExtendedFrameList&  aFrames) const;
   //virtual void  load(tStreamCIterator& iPos) {for_each(records.begin(), records.end(),  bind2nd(mem_fun(&ExtendedData::load), iPos));}
   //virtual void  save(tStream& roData) const  {for_each(records.begin(), records.end(),  bind2nd(mem_fun(&ExtendedData::save), roData));}
   virtual void  load(tStreamCIterator& /*iPos*/) {}
   virtual void  save(tStream& /*roData*/)  {}
   virtual void clear() {}
};

class AllRecords : public ExtendedDataRecord
{
public:
   AllRecords() : ExtendedDataRecord(0xff) {}
   virtual ~AllRecords() {}
};


void ExtendedDataFactory(std::vector<tU8> const& recNo);

struct collect
{
   template<typename T>
   tVoid operator() (T& p) {p.second->collect();}
};

struct clear
{
   template<typename T>
   tVoid operator() (T& p) {p.second->clear();}
};


class load
{
public:
   load();
   load(tStreamCIterator* pos) : iPos(pos) {}
   template<typename T>
   tVoid operator() (T& p) {p.second->load(*iPos);}
private:
   tStreamCIterator* iPos;
};

class save
{
public:
   save();
   save(tStream* data) : roData(data) {}
   template<typename T>
   tVoid operator() (T& p) {p.second->save(*roData);}
private:
   tStream* roData;
};

}// namespace VDD

#endif // VD_DIAGLOG_INCLUDEGUARD_ExtendedData
