//////////////////////////////////////////////////////////////////////////
// FILE:         ExtendedData.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record Extended Data IF
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 23.01.15  | BSOT Plischke                | created
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedData
   #include "ExtendedData.h"
#endif



/* --Includes. */
/*
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
*/

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/ExtendedData.cpp.trc.h"   
#endif


namespace VDD
{

void ExtendedData::setData(std::vector<tU8> const& aData)
{
   this->xData.data = aData;
}

void ExtendedData::load(tStreamCIterator& iPos)
{
   this->xData.recNo = static_cast<tU8>(*iPos++);
   ETG_TRACE_USR3_THR(( "--- ExtendedData::load RecNo=%d",this->xData.recNo));

   this->maxSize = 0;
   const size_t bits = sizeof(size_t) * 8;
   for(size_t i = 0; i < sizeof(size_t); ++i)
   {

      tU8 value = static_cast<tU8>(*iPos++);
      //this->maxSize |= (static_cast<size_t>(value) << (bits - (i * sizeof(size_t))));
      this->maxSize |= (static_cast<size_t>(value) << (bits - 8 - (i * 8))); //lint !e834
   }

   for(size_t i = 0; i < this->maxSize; ++i)
   {
      this->xData.data[i] = static_cast<tU8>(*iPos++);
      ETG_TRACE_USR3_THR(( "--- ExtendedData::load Data[%d]=%d",i,this->xData.data[i]));
   }
}

void ExtendedData::save(tStream& roData) 
{
   roData.push_back(static_cast<tS8>(this->xData.recNo));
   ETG_TRACE_USR3_THR(( "--- ExtendedData::save RecNo=%d",this->xData.recNo));
   const size_t bits = sizeof(size_t) * 8;

   for(size_t i = 0; i < sizeof(size_t); ++i)
   {
      roData.push_back(static_cast<tS8>((this->maxSize >> (bits - 8 - (i * 8))) & 0xff)); //lint !e834
      //roData.push_back(static_cast<tS8>((this->maxSize >>  (bits - (i * sizeof(size_t)))) & 0xff));
   }

   for(size_t i = 0; i < this->maxSize; ++i)
   {
      roData.push_back(static_cast<tS8>(this->xData.data[i]));
      ETG_TRACE_USR3_THR(( "--- ExtendedData::save Data[%d]=%d",i,this->xData.data[i]));
   }
}

void ExtendedData::getFrameList(tExtendedFrameList&  aFrames) const
{
   aFrames.push_back(this->xData);
}

void ExtendedDataRecord::getFrameList(tExtendedFrameList&  aFrames) const
{
   for(std::vector<ExtendedData*>::const_iterator it = this->records.begin(); it != this->records.end(); ++it)
   {
      (*it)->getFrameList(aFrames);
   }
}

void ExtendedData::clear()
{
   ETG_TRACE_USR3_THR(( "--- ExtendedData::clear"));
   for(size_t i = 0; i < this->maxSize; ++i)
   {
      this->xData.data[i] = 0;
   }
}


}// namespace VDD
