/*
 * DiaglogService.h
 *
 *  Created on: 07.07.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIALOG_SERVICE__
#define __INCLUDED_DIALOG_SERVICE__

#include "asf/core/BaseComponent.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "asf/core/ComponentFactory.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "org/bosch/cm/diagnosis/dbus/DiaglogStub.h" //lint !e451 !e537 repeatedly included header file without standard include guard

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diaglog;

class ail_tclAppAdapt;

namespace asf {

class DiaglogService
   : public BaseComponent,
     public DiaglogStub
{
   /*lint -save -e1704 class constructor could be private, because this class is not referenced at the moment. ;) */
   friend BaseComponent* ComponentFactory<DiaglogService>::getComponent();

private:
   //! default class constructor called only by ComponentFactory<DiaglogService>::getComponent()
   DiaglogService();
   /*lint -restore */

public:
   //! default class destructor
   virtual ~DiaglogService();

   // DiaglogStub
   virtual void onSaveTestResultRequest (const ::boost::shared_ptr< SaveTestResultRequest >& request);
   virtual void onClearDTCRequest (const ::boost::shared_ptr< ClearDTCRequest >& request);

protected:
   ail_tclAppAdapt* m_pAilApp;
};

} //namespace asf

#endif /* __INCLUDED_DIALOG_SERVICE__ */
