//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_ageing_single.h
// PROJECT:      G3G Core
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 27.10.05  | ESA2 Barber                  | Initial version
// 04.10.12  | BSOT Plischke                | new Diaglog
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing_single
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing_single


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing
   #include <common/framework/ageing/vd_diaglog_ageing.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
   #include <common/framework/vd_diaglog_object.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
   #include <project/framework/vd_diaglog_configuration.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif

class vdl_tclSingleAgeing: public vdl_tclAgeing
{
// construction/destruction
private:
   friend class vdl_tclReportMemory;
   vdl_tclSingleAgeing(); //lint !e1704

public:
   vdl_tclSingleAgeing(vdl_tclReportMemory* const pMemoryObject);
   virtual ~vdl_tclSingleAgeing();

// operations

   // for Each DTC
   virtual tVoid processSystemEvent(vdl_teDiaglogSystemEvent systemEvent);

   virtual tVoid onClearAll();
   virtual tVoid onClearSingle(vdl_tclReportRecord* pRecord);
   virtual tVoid onFailed(vdl_tclReportRecord* pRecord);

   virtual bool bLoad(tStreamCIterator&);
   virtual tVoid vSave(tStream&) const;

protected:
   virtual tVoid vOnAgeingEvent(const tU8 u8AgeingCounter = 0xFF);

private:
   bool doAgeing(vdl_tclReportRecord* const pReportRecord) const;
   bool doAgeingByExternalAgeingCounter(const vdl_tclReportRecord* const pReportRecord, const tU8 u8MessageCounter) const;

   tVoid vCheckForAgeing(const vdl_teDiaglogAgeingCycle ageingEvent, const tU8 u8MessageCounter = 0xFF);

// attributes
   vdl_tclReportMemory* const  m_pMemoryObject;
};


#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing_single
