//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_ageing_global.h
// PROJECT:      G3G Core
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 27.10.05  | ESA2 Barber                  | Initial version
// 04.10.12  | BSOT Plischke                | new Diaglog
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing_global
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing_global


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing
   #include <common/framework/ageing/vd_diaglog_ageing.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
   #include <common/framework/vd_diaglog_object.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
   #include <project/framework/vd_diaglog_configuration.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif


class vdl_tclGlobalAgeing: public vdl_tclAgeing
{
// construction/destruction
private:
   vdl_tclGlobalAgeing(); //lint !e1704

public:
   vdl_tclGlobalAgeing(vdl_tclReportMemory* const pMemoryObject);
   virtual ~vdl_tclGlobalAgeing();

// operations
   virtual tVoid processSystemEvent(vdl_teDiaglogSystemEvent systemEvent);
   virtual tVoid onClearAll();
   virtual tVoid onClearSingle(vdl_tclReportRecord* pRecord);
   virtual tVoid onFailed(vdl_tclReportRecord* pRecord);

   virtual bool bLoad(tStreamCIterator&);
   virtual tVoid vSave(tStream&) const;

protected:
   virtual tVoid vOnAgeingEvent(tU8 u8AgeingCounter = 1);

private:
   tVoid vDoAgeing();
   tVoid vCheckForAgeing();

// attributes
   tS8  m_s8AgeingCounter;   
   vdl_tclReportMemory* const  m_pMemoryObject;
};


#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing_global
