//////////////////////////////////////////////////////////////////////////
// FILE:         vd_DiagLog_reportRecordBase.h
// PROJECT:      Ford H/L RNS
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 27.10.05  | ESA2 Barber                  | Initial version
// 04.10.12  | BSOT Plischke                | new Diaglog
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
   #include <common/framework/vd_diaglog_object.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
   #include <project/framework/vd_diaglog_configuration.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
   #include <common/framework/vd_diaglog_typedefs.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif


class vdl_tclAgeing
{
// construction/destruction
public:
   vdl_tclAgeing();
   virtual ~vdl_tclAgeing();

// operations
   // for Each DTC
   virtual tVoid processSystemEvent(vdl_teDiaglogSystemEvent systemEvent);
   virtual bool bLoad(tStreamCIterator&) ;
   virtual tVoid vSave(tStream&) const;

   virtual tVoid onClearAll();
   virtual tVoid onClearSingle(vdl_tclReportRecord* pRecord);
   virtual tVoid onFailed(vdl_tclReportRecord* pRecord);


   static tU8 u8GetExternalAgeingCounter(){return m_u8ExternalAgeingCounter;};
   tVoid vOnExternalAgeingCounter(tU8 u8AgeingCounter); 

   static tS8 getGlobalAgeingCounter();
   static tU8 getMaxGlobalAgeingCounter();

protected:
   virtual tVoid vOnAgeingEvent(tU8 u8AgeingCounter);

// attributes
private:
   static tU8 m_u8ExternalAgeingCounter;

protected:
   static tPS8 m_ps8GlobalAgeingCounter;
   static tS8  m_s8GlobalAgeingCounter;

};


#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing
