//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_report_record.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record base class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 27.10.05  | ESA2 Barber                  | Initial version
// 15.10.12  | BSOT Plischke                | new Diaglog 
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_ageing
   #include <common/framework/ageing/vd_diaglog_ageing.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
   #include <common/framework/vd_diaglog_trace.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_system_variables
   #include <common/framework/vd_diaglog_system_variables.h>
#endif

/* --Includes. */
//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
//#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_ageing.cpp.trc.h"   
#endif


/*static*/ tU8 vdl_tclAgeing::m_u8ExternalAgeingCounter = 0;
/*static*/ tPS8 vdl_tclAgeing::m_ps8GlobalAgeingCounter = NULL;


/*static*/ tS8 vdl_tclAgeing::getGlobalAgeingCounter() 
{
   if (m_ps8GlobalAgeingCounter != NULL)
   {
      return *m_ps8GlobalAgeingCounter;
   }
   return -1;
}

/*static*/ tU8 vdl_tclAgeing::getMaxGlobalAgeingCounter()
{
   return vdl_tclGlobalSystemVariables::u8GetMaxAge();
}


///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: vdl_tclAgeing::vdl_tclAgeing
// 
// DESCRIPTION: constructor
//
// PARAMETER:  none
//
// RETURNVALUE: void
// 
///////////////////////////////////////////////////////////////////////////////////
//
vdl_tclAgeing::vdl_tclAgeing()
{
	ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::vdl_tclAgeing"));
	ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::vdl_tclAgeing"));
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: vdl_tclReportRecord::~vdl_tclReportRecord
// 
// DESCRIPTION: default destructor
//
// PARAMETER:  none
//
// RETURNVALUE: none
// 
///////////////////////////////////////////////////////////////////////////////////
//
vdl_tclAgeing::~vdl_tclAgeing()
{
	ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::~vdl_tclAgeing"));
	ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::~vdl_tclAgeing"));
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: vdl_tclAgeing::vOperatingCycleStart()
// 
// DESCRIPTION: final call at OperatingCycleEnd
//              overwritten by ageingtyp
//
// PARAMETER:  none
//
// RETURNVALUE: none
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::processSystemEvent(vdl_teDiaglogSystemEvent /*systemEvent*/)
{
	ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::processSystemEvent"));
	ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::processSystemEvent"));
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: bool vdl_tclAgeing::bLoad
// 
// DESCRIPTION: load raw vdl_tclAgeing RAM data into class members
//              overwritten by ageingtyp
//
// PARAMETER:  vdl_tclDiagLogObject::tStreamCIterator - array of log file data
//
// RETURNVALUE: bool true=succesfull / false=failed
// 
///////////////////////////////////////////////////////////////////////////////////
//
bool vdl_tclAgeing::bLoad(tStreamCIterator& /*iPos*/)
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::bLoad"));
   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::bLoad"));
   return true;
}
///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdl_tclAgeing::vSave
// 
// DESCRIPTION: save raw vdl_tclAgeing RAM data
//              overwritten by ageingtyp
//
// PARAMETER:  tStream - array to fill with class member data
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::vSave(tStream& /*roData*/)const
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::vSave"));  
   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::vSave"));
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdl_tclAgeing::vOnAgeingEvent
// 
// DESCRIPTION: internal triggered AgeingEvent 
//              overwritten by ageingtyp
//
// PARAMETER:  tU32 u32AgeingCounter
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::vOnAgeingEvent(const tU8 /*u8AgeingCounter*/)
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::vOnAgeingEvent"));  
   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::vOnAgeingEvent"));
}


///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdl_tclAgeing::onClearAll
// 
// DESCRIPTION: Clear received
//
// PARAMETER:  tU32 u32AgeingCounter
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::onClearAll()
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::onClearAll"));  
   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::onClearAll"));
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdl_tclAgeing::onClearSingle
// 
// DESCRIPTION: Clear received
//
// PARAMETER:  tU32 u32AgeingCounter
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::onClearSingle(vdl_tclReportRecord* /*pRecord*/)
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::onClearSingle"));  
   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::onClearSingle"));
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdl_tclAgeing::onFailed
// 
// DESCRIPTION: Failed received
//
// PARAMETER:  tU32 u32AgeingCounter
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::onFailed(vdl_tclReportRecord* /*pRecord*/)
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::onFailed"));  
   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::onFailed"));
}


///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tVoid vdl_tclAgeing::vOnExternalAgeingCounter
// 
// DESCRIPTION: external triggered AgeingEvent
//
// PARAMETER:  tU32 u32AgeingCounter
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
tVoid vdl_tclAgeing::vOnExternalAgeingCounter(tU8 u8AgeingCounter) 
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclAgeing::vOnExternalAgeingCounter"));  

   if(  (m_u8ExternalAgeingCounter != u8AgeingCounter)
      &&(255 != u8AgeingCounter))
   {
      ETG_TRACE_COMP_THR(( "--- vdl_tclAgeing::vOnExternalAgeingCounter => Counter=%02x(new) %02x(old)",u8AgeingCounter,m_u8ExternalAgeingCounter));
      m_u8ExternalAgeingCounter = u8AgeingCounter;
      vOnAgeingEvent(m_u8ExternalAgeingCounter);
   }

   ETG_TRACE_USR3_THR(( "<-- vdl_tclAgeing::vOnExternalAgeingCounter"));
}

