/************************************************************************
* FILE:         dia_tclUDS_DiagLogWriteTestResult.h
* PROJECT:      SGM710 
* SW-COMPONENT: Diagnostic application (Testing)
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for KWP service write test result for testing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 03.04.06  | Thiagarajan.B      | initial version
*
*************************************************************************/

#ifndef dia_tclUDS_DiagLogWriteTestResult_H
#define dia_tclUDS_DiagLogWriteTestResult_H

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include <common/interfaces/dia_IErrorLogListener.h>
#endif

class dia_tclUDS_DiagLogWriteTestResult : public dia_Routine,
                                          public dia_IErrorLogListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_tclUDS_DiagLogWriteTestResult);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclUDS_DiagLogWriteTestResult);

   public:

      dia_tclUDS_DiagLogWriteTestResult (tCString name, tU16 udsID, dia_eRoutineID routineID);
      //! start the specified routine
      virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
      //! stop the specified routine
      virtual tDiaResult stop ( std::vector<tU8>& params );
      //! return control back to the ECU for the specified signal
      virtual tDiaResult requestResult ( std::vector<tU8>& results );
      //! handle timeout from UDS session object
      virtual tVoid vOnServiceTimeout ( tVoid );

      virtual tVoid vOnDiaglogWriteTestResult(tVoid);
      virtual tVoid vOnDiaglogWriteTestError(const tU32 errCode );
};

#endif
