/************************************************************************
* FILE:         dia_tclUDS_DiagLogWriteTestResult.cpp
* PROJECT:      SGM710 
* SW-COMPONENT: Diagnostic application(Testing)
*----------------------------------------------------------------------
*
* DESCRIPTION: Class for KWP service write test result for testing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.04.06  | Thiagarajan.B      | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#include "dia_tclUDS_DiagLogWriteTestResult.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_PROD
#include "trcGenProj/Header/dia_tclUDS_DiagLogWriteTestResult.cpp.trc.h"
#endif


dia_tclUDS_DiagLogWriteTestResult::dia_tclUDS_DiagLogWriteTestResult(tCString name, tU16 udsID, dia_eRoutineID routineID)
      : dia_Routine(name, udsID, routineID, DIA_EN_RTCTRL_TYPE_LONG_TERM)
{
    ETG_TRACE_USR3_THR(("--> dia_tclUDS_DiagLogWriteTestResult::dia_tclUDS_DiagLogWriteTestResult"));

    ETG_TRACE_USR3_THR(("<-- dia_tclUDS_DiagLogWriteTestResult::dia_tclUDS_DiagLogWriteTestResult"));
}

//------------------------------------------------------------------------------

dia_tclUDS_DiagLogWriteTestResult::~dia_tclUDS_DiagLogWriteTestResult()
{
    ETG_TRACE_USR3_THR(("--> dia_tclUDS_DiagLogWriteTestResult::~dia_tclUDS_DiagLogWriteTestResult"));

    _BP_TRY_BEGIN
    {
        (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
    }
    _BP_CATCH_ALL
    {
        ETG_TRACE_ERR_THR(("dia_tclUDS_DiagLogWriteTestResult::~dia_tclUDS_DiagLogWriteTestResult - Exception caught!"));
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END

    ETG_TRACE_USR3_THR(("<-- dia_tclUDS_DiagLogWriteTestResult::~dia_tclUDS_DiagLogWriteTestResult"));
}

//------------------------------------------------------------------------------

tDiaResult
dia_tclUDS_DiagLogWriteTestResult::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_DiagLogWriteTestResult::start"));

   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   dia_IErrorLog* pErrorLog = 0;
   if ((querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS) && pErrorLog)
   {
      (tVoid) setSysAdapterListener<dia_IErrorLogListener>(this);

      tU8 au8TestResult[4] = {0};

      if (params.size() == 4)
      {
         // currently only 2 Bytes ITC supported
         au8TestResult[0] = 3; // the first byte in au8TestResult is for request length
         au8TestResult[1] = params.at(2);
         au8TestResult[2] = params.at(3);
         au8TestResult[3] = 0x01;
      }

      if ( pErrorLog->u32TestDTCStart(&au8TestResult[0]) != DIA_SUCCESS)
      {
         ETG_TRACE_ERR_THR(( "!!! dia_tclUDS_DiagLogWriteTestResult::start => ERROR: u32TestDTCStart != DIA_SUCCESS"));
      }
      else
      {
         ETG_TRACE_USR4_THR(( "--- dia_tclUDS_DiagLogWriteTestResult::start => Send Succesfully to Server"));
         eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
         retCode = DIA_SUCCESS;
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_DiagLogWriteTestResult::start"));

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_tclUDS_DiagLogWriteTestResult::stop ( std::vector<tU8>& params )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_DiagLogWriteTestResult::stop"));

   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   dia_IErrorLog* pErrorLog = 0;
   if ((querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS) && pErrorLog)
   {
      (tVoid) setSysAdapterListener<dia_IErrorLogListener>(this);

      tU8 au8TestResult[4] = {0};

      if (params.size() == 4)
      {
         // currently only 2 Bytes ITC supported
         au8TestResult[0] = 3; // the first byte in au8TestResult is for request length
         au8TestResult[1] = params.at(2);
         au8TestResult[2] = params.at(3);
         au8TestResult[3] = 0x00;
      }

      if ( pErrorLog->u32TestDTCStart(&au8TestResult[0]) != DIA_SUCCESS)
      {
         ETG_TRACE_ERR_THR(( "!!! dia_tclUDS_DiagLogWriteTestResult::stop => ERROR: u32TestDTCStart != DIA_SUCCESS"));
      }
      else
      {
         ETG_TRACE_USR4_THR(( "--- dia_tclUDS_DiagLogWriteTestResult::stop => Send Succesfully to Server"));
         eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
         retCode = DIA_SUCCESS;
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_DiagLogWriteTestResult::stop"));

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_tclUDS_DiagLogWriteTestResult::requestResult ( std::vector<tU8>& results )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_DiagLogWriteTestResult::requestResult"));

   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("requestResult --- 2");
      switch ( mStatus )
      {
         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            ETG_TRACE_ERR_THR(("!!! dia_tclUDS_DiagLogWriteTestResult::requestResult => Status NOK"));
            break;
         }

      default:
         break;
      }
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_DiagLogWriteTestResult::requestResult"));

   return retCode;
}

//------------------------------------------------------------------------------

tVoid dia_tclUDS_DiagLogWriteTestResult::vOnServiceTimeout()
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_DiagLogWriteTestResult::vOnServiceTimeout"));

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_DiagLogWriteTestResult::vOnServiceTimeout"));
}

//------------------------------------------------------------------------------

tVoid dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestResult(tVoid)
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestResult"));

   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestResult => pos response"));

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);

   mResults.push_back(0);
   mResults.push_back(0);
   mResults.push_back(0);
   mResults.push_back(0);

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestResult"));
}

//------------------------------------------------------------------------------

tVoid dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestError(const tU32 errCode )
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestResult"));

   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestError => ErrorCode = $%x",errCode));

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);

   mResults.push_back(static_cast<tU8>((errCode >> 24) & 0xFF));
   mResults.push_back(static_cast<tU8>((errCode >> 16) & 0xFF));
   mResults.push_back(static_cast<tU8>((errCode >> 8) & 0xFF));
   mResults.push_back(static_cast<tU8>((errCode >> 0) & 0xFF));

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_DiagLogWriteTestResult::vOnDiaglogWriteTestResult"));
}
