/*
 * dia_tclUDS_BD_GetLinkQuality.cpp
 *
 *  Created on: 12.18.2012
 *      Author: hyo1szh
 *--------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 28.05.14     | GPU2KOR       | implementation changed internally to request routine control for antenna field strength instead as BT supports RSSI, Link Quality
 *                                             only for Antenna field strength.
 *************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_tclUDS_BD_GetLinkQuality.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_PROD
#include "trcGenProj/Header/dia_tclUDS_BD_GetLinkQuality.cpp.trc.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureBluetooth.h"
#define DATA_START (1/*sizeof(SID)*/ + mDIDLen)
#define DATA_LENGTH 2
tU8 dia_SAFeatureBluetooth::reqBDAddress[6];
//-------------------------------------------------------------------------------

dia_tclUDS_BD_GetLinkQuality::dia_tclUDS_BD_GetLinkQuality(tCString name, tU8 sid, tU16 did):
      dia_ServiceHandlerUDS(name,sid,(tU16) did)
{
    ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_GetLinkQuality::dia_tclUDS_BD_GetLinkQuality"));

    ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_GetLinkQuality::dia_tclUDS_BD_GetLinkQuality"));
}

//-------------------------------------------------------------------------------

dia_tclUDS_BD_GetLinkQuality::~dia_tclUDS_BD_GetLinkQuality()
{
    ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_GetLinkQuality::~dia_tclUDS_BD_GetLinkQuality"));

    _BP_TRY_BEGIN
    {
        (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
    }
    _BP_CATCH_ALL
    {
        ETG_TRACE_ERR_THR(("dia_tclUDS_BD_GetLinkQuality::~dia_tclUDS_BD_GetLinkQuality - Exception caught!"));
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END

    ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_GetLinkQuality::~dia_tclUDS_BD_GetLinkQuality"));
}

//-------------------------------------------------------------------------------

tVoid
dia_tclUDS_BD_GetLinkQuality::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_GetLinkQuality::vProcessRequest"));
   DIA_TR_INF("--> dia_tclUDS_BD_GetLinkQuality::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_IBluetooth* pIBluetooth = 0;
   if ((querySysAdapterInterface<dia_IBluetooth>(&pIBluetooth) == DIA_SUCCESS) && pIBluetooth)
   {
	  (tVoid) setSysAdapterListener<dia_IBluetoothListener>(this);
      //Read the BD address of connected device from configItems
/* 	  tU16 cfgDataLen = dia_getPropertySize(DIA_PROP_SUZUKI_BT_ADDRESS);
      std::vector<tU8> au8BDAddress(cfgDataLen,0);
      tU32 retCode = dia_getProperty(DIA_PROP_SUZUKI_BT_ADDRESS,&au8BDAddress[0],&cfgDataLen); */

	  bool invalidAddress = true;
	  for (int i = 0; i<6; i++)
	  {
		 if (dia_SAFeatureBluetooth::reqBDAddress[i] != 0x00)
		 {
			invalidAddress = false;
			break;
		 }
      }
	  if (invalidAddress == true)
	  {
         DIA_TR_INF("dia_tclUDS_BD_GetLinkQuality: invalid device address!!!");
		 ETG_TRACE_ERR_THR(("dia_tclUDS_BD_GetLinkQuality::vProcessRequest BT Address invalid !!" ));
         (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
		 oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
		 vResReadyAndQuit();
		 return;
      }
      else
	  {
	     /*if ( pIBluetooth->vGetDeviceLinkQuality(1) != DIA_SUCCESS )*/ //older implementation
     	DIA_TR_INF("--> dia_tclUDS_BD_GetLinkQuality: BD=%02d:%02d:%02d:%02d:%02d:%02d",dia_SAFeatureBluetooth::reqBDAddress[0],
	               dia_SAFeatureBluetooth::reqBDAddress[1],dia_SAFeatureBluetooth::reqBDAddress[2],dia_SAFeatureBluetooth::reqBDAddress[3],dia_SAFeatureBluetooth::reqBDAddress[4],dia_SAFeatureBluetooth::reqBDAddress[5]);

		 if ( pIBluetooth->vGetBluetoothFieldstrength(&(dia_SAFeatureBluetooth::reqBDAddress[0])/*BDConnectedDeviceAddress*/) != DIA_SUCCESS )
         {
            ETG_TRACE_ERR_THR(("!!! dia_tclUDS_BD_GetLinkQuality::vProcessRequest => ERROR: vGetDeviceLinkQuality != DIA_SUCCESS"));
         }
         else
         {
            errorDetected = FALSE;
            ETG_TRACE_USR4_THR(("--- dia_tclUDS_BD_GetLinkQuality::vProcessRequest => Send Successfully to Server"));
         }
	  }
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_tclUDS_BD_GetLinkQuality::vProcessRequest => ERROR: pIBluetooth == NULL"));
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_GetLinkQuality::vProcessRequest"));
}

tVoid dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityResult( const tU8 u8LinkQuality, tU8 u8Fieldstrength )
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityResult"));

   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DATA_START + DATA_LENGTH));
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+0), u8Fieldstrength);
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+1), u8LinkQuality);

   vResReadyAndQuit();
   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityResult => RSSI:%x; u8LinkQuality:%x",u8Fieldstrength, u8LinkQuality));
   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityResult"));
}

tVoid dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityError(const tU32 errCode )
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityError"));

   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityError=> errCode=%x",errCode));
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_BD_GetLinkQuality::vOnDeviceLinkQualityError"));
}


