/************************************************************************
* FILE:         dia_tclUDS_BD_GetBDAddress.cpp
* PROJECT:      DIAG Core
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Get Display Type
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 23.09.10  | TMS Plischke       | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#include "dia_tclUDS_BD_GetBDAddress.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_PROD
#include "trcGenProj/Header/dia_tclUDS_BD_GetBDAddress.cpp.trc.h"
#endif


#define DATA_START (1/*sizeof(SID)*/ + mDIDLen)
#define DATA_LENGTH 6

//-------------------------------------------------------------------------------

dia_tclUDS_BD_GetBDAddress::dia_tclUDS_BD_GetBDAddress(tCString name, tU8 sid, tU16 did):
      dia_ServiceHandlerUDS(name,sid,(tU16) did)
{
    ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_GetBDAddress::dia_tclUDS_BD_GetBDAddress"));

    ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_GetBDAddress::dia_tclUDS_BD_GetBDAddress"));
}

//-------------------------------------------------------------------------------

dia_tclUDS_BD_GetBDAddress::~dia_tclUDS_BD_GetBDAddress()
{
    ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_GetBDAddress::~dia_tclUDS_BD_GetBDAddress"));

    _BP_TRY_BEGIN
    {
        (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
    }
    _BP_CATCH_ALL
    {
        ETG_TRACE_ERR_THR(("dia_tclUDS_BD_GetBDAddress::~dia_tclUDS_BD_GetBDAddress - Exception caught!"));
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END

    ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_GetBDAddress::~dia_tclUDS_BD_GetBDAddress"));
}

//-------------------------------------------------------------------------------

tVoid
dia_tclUDS_BD_GetBDAddress::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_GetBDAddress::vProcessRequest"));

   tBool errorDetected = TRUE;

   dia_IBluetooth* pIBluetooth = 0;
   if ((querySysAdapterInterface<dia_IBluetooth>(&pIBluetooth) == DIA_SUCCESS) && pIBluetooth)
   {
      (tVoid) setSysAdapterListener<dia_IBluetoothListener>(this);
      if ( pIBluetooth->vGetBluetoothDeviceAddress() != DIA_SUCCESS )
      {
         ETG_TRACE_ERR_THR(("!!! dia_tclUDS_BD_GetBDAddress::vProcessRequest => ERROR: vGetBluetoothDeviceAddress != DIA_SUCCESS"));
      }
      else
      {
         errorDetected = FALSE;
         ETG_TRACE_USR4_THR(("--- dia_tclUDS_BD_GetBDAddress::vProcessRequest => Send Successfully to Server"));
      }
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_tclUDS_BD_GetBDAddress::vProcessRequest => ERROR: pIBluetooth == NULL"));
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_GetBDAddress::vProcessRequest"));
}

/*************************************************************************
*
* FUNCTION: tBool vOnReadBDAddressResult()
*
* DESCRIPTION: Request Handler Function
*
* PARAMETER: none
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressResult(const tU8* const pu8Result)
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressResult"));

   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DATA_START + DATA_LENGTH));
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+0), pu8Result[0]);
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+1), pu8Result[1]);
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+2), pu8Result[2]);
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+3), pu8Result[3]);
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+4), pu8Result[4]);
   oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+5), pu8Result[5]);

   vResReadyAndQuit();
   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressResult => ID:%x:%x:%x:%x:%x:%x",pu8Result[0],pu8Result[1],pu8Result[2],pu8Result[3],pu8Result[4],pu8Result[5]));
   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressResult"));
}

/*************************************************************************
*
* FUNCTION: tVoid vOnReadBDAddressError(const tU32 errCode )
*
* DESCRIPTION: Response Handler Function Error
*
* PARAMETER: errCode: Standard Error Result
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressError (const tU32 errCode )
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressError"));

   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressError=> errCode=%x",errCode));
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_BD_GetBDAddress::vOnReadBDAddressError"));
}

