/************************************************************************
* FILE:         dia_tclUDS_BD_Connection.h
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Apple Selftest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 04.08.10  | TMS Plischke            | initial version
*--------------------------------------------------------
* Date      | Author                  | Modification
* 20.05.14  | Upasna Ghansiyal        | Implementation changed to Type-I routine control.
*
*************************************************************************/

#ifndef dia_tclUDS_BD_Connection_H
#define dia_tclUDS_BD_Connection_H

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include "project/interfaces/dia_IBluetoothListener.h"
#endif

class dia_tclUDS_BD_ConnectionControl : public dia_Routine,
                                        public dia_IBluetoothListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_tclUDS_BD_ConnectionControl);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclUDS_BD_ConnectionControl);

public:

   dia_tclUDS_BD_ConnectionControl (tCString name, tU16 udsID, dia_eRoutineID routineID);
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! stop the specified routine
//   virtual tDiaResult stop ( std::vector<tU8>& params );
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( void );
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );

   virtual void vOnConnectionControlResult ( const  tU8 u8Result, const tU8 u8ConnectionStatus);
   virtual void vOnConnectionControlError(const tU32 errCode );
};

#endif

