/************************************************************************
* FILE:         dia_tclUDS_BD_ConnectionControl.cpp
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Bluetooth Selftest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 04.08.10  | TMS Plischke            | initial version
*--------------------------------------------------------
* Date      | Author                  | Modification
* 20.05.14  | Upasna Ghansiyal        | Implementation changed to Type-I routine control.
*
*************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#include "dia_tclUDS_BD_ConnectionControl.h"

#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_PROD
#include "trcGenProj/Header/dia_tclUDS_BD_ConnectionControl.cpp.trc.h"
#endif

#define DIA_C_U16_CTRL_VALUE_CONNECT    ((tU8) 0x01)
#define DIA_C_U16_CTRL_VALUE_DISCONNECT ((tU8) 0x00)

dia_tclUDS_BD_ConnectionControl::dia_tclUDS_BD_ConnectionControl (tCString name, tU16 udsID, dia_eRoutineID routineID)
   : dia_Routine(name, udsID, routineID,DIA_EN_RTCTRL_TYPE_LONG_TERM)
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::dia_tclUDS_BD_ConnectionControl"));

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_ConnectionControl::dia_tclUDS_BD_ConnectionControl"));
}

//------------------------------------------------------------------------------

dia_tclUDS_BD_ConnectionControl::~dia_tclUDS_BD_ConnectionControl ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::~dia_tclUDS_BD_ConnectionControl"));

   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_tclUDS_BD_ConnectionControl::~dia_tclUDS_BD_ConnectionControl !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::~dia_tclUDS_BD_ConnectionControl"));
}

//------------------------------------------------------------------------------

tDiaResult
dia_tclUDS_BD_ConnectionControl::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::start"));

   tDiaResult retCode = DIA_FAILED;

   tenDiaglibConnection eType = EN_ConnectionDISCONECT;

   // prepare processing of the routine
   vInitialize();
   if (params.size() != 18) 
   {
      DIA_TR_INF("INVALID PARAMETERS");
      return DIA_FAILED;
   }
// extract control option 
   DIA_TR_INF("dia_tclUDS_BD_ConnectionControl::start ---- extracting control option");
   switch ( params.at(0) )
   {
    case DIA_C_U16_CTRL_VALUE_CONNECT:
		eType = EN_ConnectionCONNECT;
        break;

    case DIA_C_U16_CTRL_VALUE_DISCONNECT:
        eType = EN_ConnectionDISCONECT;
        break;

    default:
        DIA_TR_INF( "Unknown Ctrl Value 0x%02x",params[0]);
        return DIA_FAILED;
   }	
   dia_IBluetooth* pIBluetooth = 0;
   if ( querySysAdapterInterface<dia_IBluetooth>(&pIBluetooth) == DIA_SUCCESS )
   {
      if ( pIBluetooth )
      {
         (tVoid) setSysAdapterListener<dia_IBluetoothListener>(this);
		tU8 au8BDAddress[17]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
            for (unsigned int i=0; i<17;i++)
            {
               au8BDAddress[i] = params.at(i+1);
            }
		
		if ( pIBluetooth->vStartConnectBluetoothDeviceAddress(eType, &au8BDAddress[0]) != DIA_SUCCESS)
         {
            ETG_TRACE_ERR_THR(( "!!! dia_tclUDS_BD_ConnectionControl::start => ERROR: vStartConnectBluetoothDeviceAddress != DIA_SUCCESS"));
         }
         else
         {
            ETG_TRACE_USR4_THR(( "--- dia_tclUDS_BD_ConnectionControl::start => Send Succesfully to Server"));
            eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
            retCode = DIA_SUCCESS;
         }
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_ConnectionControl::start"));

   return retCode;
}

//------------------------------------------------------------------------------
#if 0 // Feature is implemented as a type-1 routine control
tDiaResult
dia_tclUDS_BD_ConnectionControl::stop ( std::vector<tU8>& params )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::stop"));

   tDiaResult retCode = DIA_FAILED;

   tenDiaglibConnection eType = EN_ConnectionDISCONECT;

   // prepare processing of the routine
   vInitialize();

   dia_IBluetooth* pIBluetooth = 0;
   if ( querySysAdapterInterface<dia_IBluetooth>(&pIBluetooth) == DIA_SUCCESS )
   {
      if ( pIBluetooth )
      {
         (tVoid) setSysAdapterListener<dia_IBluetoothListener>(this);

         tU8 au8BDAddress[6]={0,0,0,0,0,0};
         tU8 au8MacAddress[6]={0,0,0,0,0,0};

         if (params.size() == 12)
         {
            for (int i=0; i<6;i++)
            {
               au8BDAddress[i] = params.at(i);
            }
            for (int i=0; i<6;i++)
            {
               au8MacAddress[i] = params.at(6+i);
            }
         }
         char outputstring[150];
         sprintf((char*) outputstring,"--- dia_tclUDS_BD_ConnectionControl::stop => Type =%x MAC=%02x:%02x:%02x:%02x:%02x:%02x  BD=%02x:%02x:%02x:%02x:%02x:%02x",
               eType,au8MacAddress[0],au8MacAddress[1],au8MacAddress[2],au8MacAddress[3],au8MacAddress[4],au8MacAddress[5],au8BDAddress[0],au8BDAddress[1],au8BDAddress[2],au8BDAddress[3],au8BDAddress[4],au8BDAddress[5]);
         ETG_TRACE_COMP_THR(( "%s",outputstring));

         if ( pIBluetooth->vStartConnectBluetoothDeviceAddress(eType, &au8BDAddress[0], &au8MacAddress[0]) != DIA_SUCCESS)
         {
            ETG_TRACE_ERR_THR(( "!!! dia_tclUDS_BD_ConnectionControl::stop => ERROR: vStartConnectBluetoothDeviceAddress != DIA_SUCCESS"));
         }
         else
         {
            ETG_TRACE_USR4_THR(( "--- dia_tclUDS_BD_ConnectionControl::stop => Send Succesfully to Server"));
            eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
            retCode = DIA_SUCCESS;
         }
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_ConnectionControl::stop"));

   return retCode;
}
#endif
//------------------------------------------------------------------------------

tDiaResult
dia_tclUDS_BD_ConnectionControl::requestResult ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::requestResult"));

   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   dia_IBluetooth* pIBluetooth = 0;
   if ( querySysAdapterInterface<dia_IBluetooth>(&pIBluetooth) == DIA_SUCCESS )
   {
      if ( pIBluetooth )
      {
         (tVoid) setSysAdapterListener<dia_IBluetoothListener>(this);

         if ( pIBluetooth->vGetStatusConnectBluetoothDeviceAddress() != DIA_SUCCESS)
         {
            ETG_TRACE_ERR_THR(( "!!! dia_tclUDS_BD_ConnectionControl::requestResult => ERROR: vGetStatusConnectBluetoothDeviceAddress != DIA_SUCCESS"));
         }
         else
         {
            ETG_TRACE_USR4_THR(( "--- dia_tclUDS_BD_ConnectionControl::requestResult => Send Succesfully to Server"));
            eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
            retCode = DIA_SUCCESS;
         }

      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   }

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_ConnectionControl::requestResult"));

   return retCode;
}

//------------------------------------------------------------------------------

tVoid
dia_tclUDS_BD_ConnectionControl::vOnConnectionControlResult ( tU8 u8Result, tU8 u8ConnetionStatus )
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_BD_ConnectionControl::vOnConnectionControl"));

   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_BD_ConnectionControl::vOnConnectionControl => Result: %d , ConnetionStatus: %d",u8Result, u8ConnetionStatus));
   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);

   mResults.push_back(u8Result);
   mResults.push_back(u8ConnetionStatus);
   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_BD_ConnectionControl::vOnConnectionControl"));
}

//------------------------------------------------------------------------------

tVoid dia_tclUDS_BD_ConnectionControl::vOnConnectionControlError (const tU32 errCode )
{
   ETG_TRACE_USR3_THR(( "--> dia_tclUDS_BD_ConnectionControl::vOnConnectionControlError"));

   ETG_TRACE_COMP_THR(( "--- dia_tclUDS_BD_ConnectionControl::vOnConnectionControlError=> errCode=%x",errCode));

   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);

   ETG_TRACE_USR3_THR(( "<-- dia_tclUDS_BD_ConnectionControl::vOnConnectionControlError"));
}

//------------------------------------------------------------------------------

tDiaResult
dia_tclUDS_BD_ConnectionControl::requestResult ( std::vector<tU8>& results )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::requestResult"));

   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("requestResult --- 2");
      switch ( mStatus )
      {
         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            ETG_TRACE_ERR_THR(("!!! dia_tclUDS_BD_ConnectionControl::requestResult => Status NOK"));
            break;
         }

      default:
         break;
      }
   }

   //Prepare for later asynchronous call to dia_tclUDS_BD_ConnectionControl::requestResult(tVoid)
   mIsResultReady = FALSE;

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_ConnectionControl::requestResult"));

   return retCode;
}

//------------------------------------------------------------------------------

tVoid
dia_tclUDS_BD_ConnectionControl::vOnServiceTimeout ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_tclUDS_BD_ConnectionControl::vOnServiceTimeout"));

   ETG_TRACE_ERR_THR(("!!! dia_tclUDS_BD_ConnectionControl::vOnServiceTimeout"));
   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   ETG_TRACE_USR3_THR(("<-- dia_tclUDS_BD_ConnectionControl::vOnServiceTimeout"));
}

