/*
 * dia_SrvHandler_WriteNaviUnit.cpp
 *
 * \author  wgl2hi
 * \date    2015/09/24
 *
 */

#define SYSTEM_S_IMPORT_INTERFACE_FFD_DEF
#include "system_pif.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "dia_SrvHandler_WriteNaviUnit.h"

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define MSG_DATA_OFFSET    4
#define DATA_START         3
#define NAVI_UNIT_DATA_LEN 8

//-----------------------------------------------------------------------------

dia_SrvHandler_WriteNaviUnit::dia_SrvHandler_WriteNaviUnit ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteNaviUnit::dia_SrvHandler_WriteNaviUnit(tCString,tU8,tU16)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_WriteNaviUnit::~dia_SrvHandler_WriteNaviUnit ( tVoid )
{}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_WriteNaviUnit::vProcessRequest ( const std::vector<tVoid*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteNaviUnit::vOnProcessRequest");

   if ( !(vecArgs.size()) )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_WriteNaviUnit::vProcessRequest FAILED (Property Not Available) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   tU32 propID = (tU32) vecArgs[0];

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   tU8 propData[DIA_PROP_LENGTH_MAX] = {0};
   (void) ::memset(propData,0,DIA_PROP_LENGTH_MAX);

   std::vector<tU8> vecNaviUnitata;

   tU16 u16DataLength = oDiagMsgBuffer().u16GetDataLength();
   if ((u16DataLength - MSG_DATA_OFFSET) != NAVI_UNIT_DATA_LEN)
   {
      DIA_TR_INF("dia_SrvHandler_WriteNaviUnit::vProcessRequest Navi Unit data shall have 8 bytes !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
      return;
   }

   tU16 i;
   for (i= 0; i < NAVI_UNIT_DATA_LEN; i++)
   {
      propData[i] = pU8[i+MSG_DATA_OFFSET];
      DIA_TR_INF("dia_SrvHandler_WriteNaviUnit::vProcessRequest vecNaviUnitata[%d] 0x%02x", i, propData[i]);
      vecNaviUnitata.push_back(propData[i]);
   }

   if ( dia_setProperty(propID, vecNaviUnitata) != DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: writing Navi Unit in KDS REJECTED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_PROGRAMMING_FAILURE);
      return;
   }

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START);
   vResReadyAndQuit();
}
