/*!
 * \file       dia_SrvHandler_WireSpeedInformationGPIO.cpp
 *
 * \brief      Service handler for read out of digital state of input GPIO
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include "dia_SrvHandler_WireSpeedInformationGPIO.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH                     ((tU16) (1 + mDIDLen))
#define DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_SIZE          0x01U
#define DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_MAX_VALUE     0x01U /* possible value: 0 or 1 (binary value) */

//-----------------------------------------------------------------------------

dia_SrvHandler_WireSpeedInformationGPIO::dia_SrvHandler_WireSpeedInformationGPIO ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_WireSpeedInformationGPIO", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_UNUSED_EXT_IN_WIRE_SPEED_INFO /*DID*/)
{
#ifndef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandler_WireSpeedInformationGPIO::dia_SrvHandler_WireSpeedInformationGPIO(void)");
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandler_WireSpeedInformationGPIO::~dia_SrvHandler_WireSpeedInformationGPIO ( void )
{}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_WireSpeedInformationGPIO::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireSpeedInformationGPIO::vProcessRequest");

   tU32 size = DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_SIZE;
   tU8 data[DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_SIZE] = {0};

   tDiaResult retCode = dia_getProperty(DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO, data, &size);
   if ( (DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_SIZE!=size) || (DIA_SUCCESS!=retCode) || (data[0]>DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_MAX_VALUE))
   {
      if (DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_SIZE!=size) DIA_TR_ERR("dia_SrvHandler_WireSpeedInformationGPIO::vProcessRequest size=0x%08X FAILED ###", size);
      if (DIA_SUCCESS != retCode)   DIA_TR_ERR("dia_SrvHandler_WireSpeedInformationGPIO::vProcessRequest retCode=0x%08X FAILED ###", retCode);
      else                          DIA_TR_ERR("dia_SrvHandler_WireSpeedInformationGPIO::vProcessRequest data[0]=0x%02X FAILED exp leass than 2. ###", data[0]);

      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_WireSpeedInformationGPIO::vProcessRequest SUCCESS data[0]=0x%02X", data[0]);

      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO_SIZE);
      (void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 0, data[0]);
      vResReadyAndQuit();
   }
}
