/*
 * dia_SrvHandler_ReadNaviUnit.cpp
 *
 *  Created on: 24.09.2015
 *      Author:
 */
// TTFis:\> DIA_REQ UDS 03 22 20 10

#include "dia_SrvHandler_ReadNaviUnit.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadNaviUnit::dia_SrvHandler_ReadNaviUnit ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadNaviUnit", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_NAVI_UNIT /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadNaviUnit::dia_SrvHandler_ReadNaviUnit(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadNaviUnit::~dia_SrvHandler_ReadNaviUnit ( void )
{}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadNaviUnit::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadNaviUnit::vOnProcessRequest");

   if ( vecArgs.size() )
   {
      tU32 propID = (tU32) vecArgs[0];
      std::vector<tU8> u8DataNaviUnit;

      tDiaResult retCode = dia_getProperty(propID, u8DataNaviUnit);
      if ( retCode != DIA_SUCCESS )
      {
		 DIA_TR_INF("Read Navi Unit failed!!!");
		 vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
		 return;
	   }

 	   // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + (tU16) (u8DataNaviUnit.size()));

      for ( tU16 i = 0; i < u8DataNaviUnit.size(); ++i)
      {
	      (void) oDiagMsgBuffer().vSetDataU8(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + i, u8DataNaviUnit[i]);
	   }
      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_ReadNaviUnit::vProcessRequest Property not passed as parameter.");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
