/*
 * dia_SrvHandler_AIVI_VariantCoding_Write.cpp
 *
 * \author  shw2abt
 * \date    09.10.2015
 *
 */

#define SYSTEM_S_IMPORT_INTERFACE_FFD_DEF
#include "system_pif.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef dia_SrvHandler_AIVI_VARIANT_CODING_WRITE_H_
#include "dia_SrvHandler_AIVI_VariantCoding_Write.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include <project/framework/config/dia_defsProjectConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#define MSG_DATA_OFFSET    4
#define DATA_START         3
#define DATA_LENGTH        DIA_AIVI_VARIANT_CODING_LENGTH
#define VARIANT_TYPE_MAX   0x03
#define CONFI_SET_MAX      0x02
#define VARIANT_TYPE_CC    0x04

//-----------------------------------------------------------------------------

dia_SrvHandler_AIVI_VariantCoding_Write::dia_SrvHandler_AIVI_VariantCoding_Write ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_AIVI_VariantCoding_Write",DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_AIVI_VARIANT_CODING)
{
   dia_tclFnctTrace trc("dia_SrvHandler_AIVI_VariantCoding_Write::dia_SrvHandler_AIVI_VariantCoding_Write(tCString,tU8,tU16)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_AIVI_VariantCoding_Write::~dia_SrvHandler_AIVI_VariantCoding_Write ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_AIVI_VariantCoding_Write::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_AIVI_VariantCoding_Write::vOnProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU8 u8propData[DIA_PROP_LENGTH_MAX];
   (tVoid) ::memset(u8propData,0,DIA_PROP_LENGTH_MAX);

   // copy only needed Bytes - normally copy is done until end of msg. (max ms length == 240B) or '\0' (0x0)
   tU16 no_of_bytes = dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING);
   if(no_of_bytes==DATA_LENGTH){
      for (tU16 u16EleCount = 0 ; u16EleCount<no_of_bytes ; u16EleCount++){
         u8propData[u16EleCount] = pU8[u16EleCount+MSG_DATA_OFFSET];
         DIA_TR_INF("dia_SrvHandler_AIVI_VariantCoding_Write::vProcessRequest u8propData[%d] 0x%02x", u16EleCount, u8propData[u16EleCount]);
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_AIVI_VariantCoding_Write::vProcessRequest INTERNAL ERROR LENGTH IS=%d;SHOULD=%d, ", no_of_bytes, DATA_LENGTH);
      vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_PROGRAMMING_FAILURE);
      return;
   }

   // check received data if it fits to CDD
   // Byte 0 - VariantConfig
   // Byte 0 - right nibble - Variant Selection
   tU8 rNibble = u8propData[0] & 0x0F;
   if((rNibble<=VARIANT_TYPE_MAX) || (rNibble == VARIANT_TYPE_CC)){
      DIA_TR_INF("dia_SrvHandler_AIVI_VariantCoding_Write::vProcessRequest VariantType is 0x%02x .", rNibble);
      // Byte 0 - left nibble - ActiveConfigurationSet
      tU8 lNibble = u8propData[0] & 0xF0;
      lNibble = lNibble>>4;//Coverity fix(CID:19060)
      if(lNibble<=CONFI_SET_MAX){
         DIA_TR_INF("dia_SrvHandler_AIVI_VariantCoding_Write::vProcessRequest ConfigurationSet is 0x%02x .", lNibble);
         // Byte 1 - reserved
         // --> not checked

         // write data
         if (dia_setProperty(DIA_PROP_AIVI_VARIANT_CODING, u8propData, DATA_LENGTH) == DIA_SUCCESS) {
            oDiagMsgBuffer().vSetPosResp();
            oDiagMsgBuffer().vSetDataLength(DATA_START);
            vResReadyAndQuit();
         } else {
            DIA_TR_INF("dia_SrvHandler_AIVI_VariantCoding_Write::vProcessRequest setProperty FAILED!");
            vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_PROGRAMMING_FAILURE);
//         return;
         }
      } else {
         DIA_TR_ERR("dia_SrvHandler_AIVI_VariantCoding_Write:: ConfigurationSet wrong (IS=0x%02x; MAX=0x%02x) !", lNibble, CONFI_SET_MAX);
      }
   } else {
      DIA_TR_ERR("dia_SrvHandler_AIVI_VariantCoding_Write:: VariantType wrong (IS=0x%02x; MAX=0x%02x) !", rNibble, VARIANT_TYPE_MAX);
   }
//   return;
}
