/*!
 * \file       dia_RtCtrlClearMCANConnectionHistory.cpp
 *
 * \brief      This RTCtrl Service has to delete all MCAN Histories, e.g. with the components Meter and TCU_USB. Therefore it uses the SystemSettingFramework to handle flexible
 *             all linked components.
 *
 * \details    tbd
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesProject
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#include "dia_RtCtrlClearMCANConnectionHistory.h"

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS__
#include <common/interfaces/dia_ISystemSettings.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

static tU8 sResultMapping[DIA_EN_RTCTRL_STATUS_COUNT] = {
      0xFF, // DIA_EN_RTCTRL_STATUS_UNKNOWN
      0xFF, // DIA_EN_RTCTRL_STATUS_IDLE
      0xFF, // DIA_EN_RTCTRL_STATUS_IN_PROGRESS
      0x00, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK
      0x01, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK
      0xFF, // DIA_EN_RTCTRL_STATUS_ABORTED
      0xFF  // DIA_EN_RTCTRL_STATUS_TIMED_OUT
};

//------------------------------------------------------------------------------

dia_RtCtrlClearMCANConnectionHistory::dia_RtCtrlClearMCANConnectionHistory ( void )
   : dia_Routine("dia_RtCtrlClearMCANConnectionHistory", DIA_C_U16_DID_AIVI_CLEAR_MCAN_CONNECTION_HISTORY, DIA_EN_RTCTRL_ID_CLEAR_MCAN_CONNECTION_HISTORY)/*,
     mIsLockRequired(false)*/
{
   dia_tclFnctTrace oTrace("dia_RtCtrlClearMCANConnectionHistory::dia_RtCtrlClearMCANConnectionHistory()");
}

//------------------------------------------------------------------------------

dia_RtCtrlClearMCANConnectionHistory::~dia_RtCtrlClearMCANConnectionHistory ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia_RtCtrlClearMCANConnectionHistory::~dia_RtCtrlClearMCANConnectionHistory - Exception caught");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrlClearMCANConnectionHistory::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlClearMCANConnectionHistory::start()");

   // prepare processing of the routine
   vInitialize();

   if ( params.size() != 0 ) {
      DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::start INVALID PARAMETERS");
      return DIA_FAILED;
   }

   dia_ISystemSettings* pInterface = 0;
   tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ((retCode == DIA_SUCCESS) && pInterface) {
      if (DIA_SUCCESS == pInterface->processSystemSetting(DIA_C_UID_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES, *this, this)) {
         DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::start processSystemSetting is success.");
         eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
         retCode = DIA_SUCCESS;
      } else {
         DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::start no flush done!!!");
         mResults.push_back(sResultMapping[DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK]);
         mIsResultReady = TRUE;
         eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrlClearMCANConnectionHistory::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlClearMCANConnectionHistory::requestResult()");

   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;

   DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::requestResult: mStatus = %d", mStatus);

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("requestResult --- 2");
      switch ( mStatus )
      {
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            DIA_TR_INF("requestResult --- 3 (Status %d) --> return value 0x%02x", mStatus, sResultMapping[mStatus]);
            // collect results
            results.push_back(sResultMapping[mStatus]);
            mIsResultReady = TRUE;
            retCode = DIA_SUCCESS;
         }
         break;

      default:
         DIA_TR_INF("requestResult --- 4");
         break;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_RtCtrlClearMCANConnectionHistory::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlClearMCANConnectionHistory::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

void
dia_RtCtrlClearMCANConnectionHistory::onSystemSettingProcessed( dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult resultCode, void* cookie )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlClearMCANConnectionHistory::onSystemSettingProcessed()");

   if ( cookie != ((void*) this) ) return;

   if(resultCode==DIA_FAILED){
      DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::onSystemSettingProcessed result DIA_FAILED.");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   } else {
      DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::onSystemSettingProcessed result DIA_SUCCESS.");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

//-----------------------------------------------------------------------------

void
dia_RtCtrlClearMCANConnectionHistory::vOnLockDevice ( tDiaResult retCode )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlClearMCANConnectionHistory::vOnLockDevice()");
   (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);

   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_RtCtrlClearMCANConnectionHistory::vOnLockDevice (COMPLETED_AND_NOK");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }
   else
   {
      DIA_TR_ERR("dia_RtCtrlClearMCANConnectionHistory::vOnLockDevice (COMPLETED_AND_NOK) -- FAILED TO LOCK DEVICE !!!");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}
