/*
 * dia_RoutineCtrlStartSoftwareUpdateOfAllSubModules.h
 *
 *  Created on: 27.03.2017
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_START_SW_UPDATE_OF_ALL_SUBMODULES__
#define __INCLUDED_DIA_ROUTINE_CTRL_START_SW_UPDATE_OF_ALL_SUBMODULES__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATE_LISTENER__
#include "common/interfaces/dia_ISwUpdateListener.h"
#endif


namespace dia
{

class RoutineCtrlStartSoftwareUpdateOfAllSubModules
   : public dia_Routine,
     public dia_ISwUpdateListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlStartSoftwareUpdateOfAllSubModules);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlStartSoftwareUpdateOfAllSubModules);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ISwUpdateListenerImpl methods
   //
   //-------------------------------------------------------------------------
   //! routine control status handling function
   virtual void vOnUpdateAllSubModules (bool bOk, dia_eSwUpdateError& eResult );

};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_START_SW_UPDATE_OF_ALL_SUBMODULES__ */

