/*
 * dia_RoutineCtrlStartSoftwareUpdateOfAllSubModules.cpp
 *
 *  Created on: 27.03.2017
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_START_SW_UPDATE_OF_ALL_SUBMODULES__
#include <project/services/production/dia_RoutineCtrlStartSoftwareUpdateOfAllSubModules.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include <common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h>
#endif

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlStartSoftwareUpdateOfAllSubModules::RoutineCtrlStartSoftwareUpdateOfAllSubModules(void)
   :  dia_Routine("dia_RoutineCtrlStartSoftwareUpdateOfAllSubModules",
         DIA_C_U16_ID_RTCTRL_START_SWUPDATE_OF_ALL_SUBMODULES)
{
   dia_tclFnctTrace oTrace("RoutineCtrlStartSoftwareUpdateOfAllSubModules::RoutineCtrlStartSoftwareUpdateOfAllSubModules");
}

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlStartSoftwareUpdateOfAllSubModules::~RoutineCtrlStartSoftwareUpdateOfAllSubModules ( void )
{
   _BP_TRY_BEGIN
   {
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("RoutineCtrlStartSoftwareUpdateOfAllSubModules::~RoutineCtrlStartSoftwareUpdateOfAllSubModules - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlStartSoftwareUpdateOfAllSubModules::start ( std::vector<tU8>& params, tU8 timerValue )
{
   dia_tclFnctTrace oTrace("RoutineCtrlStartSoftwareUpdateOfAllSubModules::start()");

   // prepare processing of the routine
   vInitialize();

   tBool errorDetected = TRUE;

   dia_ISwUpdate* pInterface = OSAL_NULL;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISwUpdate>(&pInterface);

   if (diaResult == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (void) setSysAdapterListener<dia_ISwUpdateListener>(this);

         if (pInterface->updateAllSubModules() == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_ERR("RoutineCtrlStartSoftwareUpdateOfAllSubModules::start --- SEND TO SW UPDATE SERVER FAILED !!!");
         }
      }
      else
      {
         DIA_TR_ERR("RoutineCtrlStartSoftwareUpdateOfAllSubModules::start --- pInterface is NULL.");
      }
   }

   if ( errorDetected )
   {
     DIA_TR_ERR("RoutineCtrlStartSoftwareUpdateOfAllSubModules::start -- errorDetected TRUE !!!");

     eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
     mIsResultReady = TRUE;
   }
   else
   {
     eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlStartSoftwareUpdateOfAllSubModules::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("RoutineCtrlStartSoftwareUpdateOfAllSubModules::requestResult()");

   tDiaResult retCode = DIA_SUCCESS;

   results.clear();

   switch ( mStatus )
   {
   case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
      results.push_back(0x00);
      break;

   case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
      results.push_back(0x01);
      break;

   default:
      DIA_TR_ERR("INCORRECT STATUS: 0x%x", mStatus);
      retCode = DIA_E_SEQUENCE_ERROR;
      break;

   }

   return retCode;
}

//------------------------------------------------------------------------------

void
RoutineCtrlStartSoftwareUpdateOfAllSubModules::vOnUpdateAllSubModules (bool bOk, dia_eSwUpdateError& eResult )
{
   dia_tclFnctTrace oTrace("RoutineCtrlStartSoftwareUpdateOfAllSubModules::vOnUpdateAllSubModules()");

   if (bOk && (eResult == DIA_EN_UPDATE_ERROR_OK ))
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);

   // call requestResult (send positive answer) and then wait for reset
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

} //namespace dia
