/**
 * \file      dia_RoutineCtrlSWUPUpdateMapData.h
 *
 * \date      23.03.2017
 *
 * \autor     kaa1hi
 *
 * \brief     Routine to trigger full map update for Navi
 *
 * \details   31 01 11 11
 *
 * \copyright Robert Bosch GmbH 2017
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SWUP_UPDATE_MAP_DATA__
#define __INCLUDED_DIA_ROUTINE_CTRL_SWUP_UPDATE_MAP_DATA__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__
#include <common/services/uds/generic/dia_RoutineCtrlExecuteSystemCommand.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATIONDATAUPDATE_LISTENER__
#include "project/interfaces/dia_IHMINavigationDataUpdateListener.h"
#endif

namespace dia
{

class RoutineCtrlSWUPUpdateMapData
   : public dia_Routine,
     public dia_IHMINavigationDataUpdateListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlSWUPUpdateMapData);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlSWUPUpdateMapData);

public:

   virtual tDiaResult tearDown ( void );

   virtual void vOnServiceTimeout ( void );

   virtual tDiaResult start ( std::vector<tU8>& params, tU8 /*timerValue*/ );

   virtual tDiaResult requestResult( std::vector<tU8>& results );

   virtual tDiaResult stop ( std::vector<tU8>& /*params*/)
   {
      DIA_TR_ERR("### dia::RoutineCtrlSWUPUpdateMapData::stop NOT SUPPORTED!!! ###");
      DIA_TR_ERR("### DIA_E_SUBFUNCTION_NOT_SUPPORTED ###");
      return DIA_E_SUBFUNCTION_NOT_SUPPORTED;
   }

protected:
   //! response to performFullUpdateViaUSB methods (called in start)
   virtual void vOnPerformFullUpdateViaUSB ( dia_eFullUpdateViaUSBConfirmation /*ack*/ );

   //! response to getNavDataUpdateStatus methods (called in requestResult)
   virtual void vOnGetNavDataUpdateStatus (  tU8 /*progress*/, dia_eMapUpdateStatus /*updateStatus*/  );

private:
   static const tU32 MAX_PROGRESS       = 100;   //percentage value
   static const tU32 DEFAULT_PROGRESS   = 0;

   tU8 mProgress;
};

}

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_SWUP_UPDATE_MAP_DATA__ */

