/*
 * dia_RoutineCtrlGenerateKeyPair.cpp
 *
 *  Created on: 29.11.2016
 *      Author: kaa1hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERATE_KEY_PAIR__
#include <project/services/production/dia_RoutineCtrlGenerateKeyPair.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include <common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

static const std::string fullCmdName("/bin/bash");

// Log file is used for trace only.
//static const std::string logFilePathName     ("/tmp/tt_ams/logs/genKeyPair.log");
static const std::string scriptFilePathName  ("/opt/bosch/security/PartAuthentication/Scripts/genKeyPair.sh");

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlGenerateKeyPair::RoutineCtrlGenerateKeyPair(void)
   : RoutineCtrlExecuteSystemCommand("Routine for GenerateKeyPair", DIA_C_U16_ID_RTCTRL_KEY_PAIR_GENERATION, fullCmdName)
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenerateKeyPair::RoutineCtrlGenerateKeyPair");
   mType=DIA_EN_RTCTRL_TYPE_LONG_TERM;
}

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlGenerateKeyPair::~RoutineCtrlGenerateKeyPair ( void )
{
   _BP_TRY_BEGIN
   {
      (void) RoutineCtrlGenerateKeyPair::tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia::RoutineCtrlGenerateKeyPair::~RoutineCtrlGenerateKeyPair - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenerateKeyPair::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenerateKeyPair::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenerateKeyPair::getCommandArguments ( std::vector<std::string>& argv )
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenerateKeyPair::getCommandArguments");

   argv.push_back(scriptFilePathName);

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

bool
RoutineCtrlGenerateKeyPair::isExisting ( void )
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenerateKeyPair::isExisting");

   bool retCode = true;

   if ( ::access(scriptFilePathName.c_str(), F_OK) == -1 )
   {
      // the script is not existing
      DIA_TR_ERR("##### SCRIPT NOT FOUND (\"%s\") #####", scriptFilePathName.c_str());
      // do not continue otherwise execv will crash
      mErrorCode = DIA_E_GENERAL_REJECT;
      mResponseStatus = ROUTINE_NOK;
      retCode = false;
   }

   if (retCode)
   {
      DIA_TR_INF("dia::RoutineCtrlGenerateKeyPair::isExisting - Check interpreter.");

      //check script interpreter - execute base method
      retCode = RoutineCtrlExecuteSystemCommand::isExisting();
   }

   DIA_TR_INF("##### dia::RoutineCtrlGenerateKeyPair::isExisting => RETURNS \"%s\" #####", (retCode) ? "TRUE" : "FALSE");

   return retCode;
}

}
