/*
 * dia_IOCtrlInputHdlPressedKeyPrj.h
 *
 *  Created on: Jul 10, 2019
 *      Author: hgr6kor
 */

#ifndef __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_PRJ_H__
#define __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_PRJ_H__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__
#include "project/interfaces/dia_IInputHandlingPrjListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ__
#include "project/interfaces/dia_IInputHandlingPrj.h"
#endif



////////////////////////////////////////////////////////////////////////////////

#define DIA_KEYCODE_INPUT_INF4CV_MCP_HOME_COCKPIT                  0x03CF
#define DIA_KEYCODE_INPUT_INF4CV_MCP_SRC_COCKPIT                   0x03D0
#define DIA_KEYCODE_INPUT_INF4CV_MCP_NAV                           0x03D1
#define DIA_KEYCODE_INPUT_INF4CV_MCP_MAP                           0x03D2
#define DIA_KEYCODE_INPUT_INF4CV_MCP_SRC_CABIN                     0x03D3
#define DIA_KEYCODE_INPUT_INF4CV_MCP_HOME_CABIN                    0x03D4
#define DIA_KEYCODE_INPUT_INF4CV_MCP_SET_COCKPIT                   0x03D5
#define DIA_KEYCODE_INPUT_INF4CV_MCP_CAM                           0x03D6
#define DIA_KEYCODE_INPUT_INF4CV_MCP_PHONE_ACCEPT                  0x03D7
#define DIA_KEYCODE_INPUT_INF4CV_MCP_PHONE_REJECT                  0x03D8
#define DIA_KEYCODE_INPUT_INF4CV_MCP_MON                           0x03D9
#define DIA_KEYCODE_INPUT_INF4CV_MCP_SET_CABIN                     0x03DA
#define DIA_KEYCODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT  0x03DB
#define DIA_KEYCODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN    0x03DC
#define DIA_KEYCODE_INPUT_INF4CV_MCP_POWER                         0x030F
#define DIA_KEYCODE_INPUT_INF4CV_MCP_POWER_LONG                    0x02d2


class dia_IOCtrlInputHdlPressedKeyPrj
	: public dia_IOCtrlSignal,
	  public dia_IInputHandlingPrjListenerImpl
{
public:
   //! class constructor
		dia_IOCtrlInputHdlPressedKeyPrj ( void );
   //! class destructor
   virtual ~dia_IOCtrlInputHdlPressedKeyPrj ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );
   //!
   virtual void vOnSetKey ( const tDiaResult eDiaResult );

protected:
   //!
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //!
   tDiaResult triggerKey ( dia_eInputHandlingKeyInfoPrj eKeyInfo ) const;
   //!
   tBool bPressDone;
   //!
   tU16 u16KeyCode;

   dia_eVdInuptHandlingKeyCodePrj KeyID;

   dia_eVdInuptHandlingKeyCodePrj getInputHandlingKeyCode ( tU16 u16KeyCode );
};

#endif /* __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_PRJ_H__ */
