/*
 * dia_IOCtrlInputHdlPressedKeyPrj.cpp
 *
 *  Created on: Jul 10, 2019
 *      Author: hgr6kor
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_PRJ_H__
#include "dia_IOCtrlInputHdlPressedKeyPrj.h"
#endif



#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"


//------------------------------------------------------------------------------

dia_IOCtrlInputHdlPressedKeyPrj::dia_IOCtrlInputHdlPressedKeyPrj ( void )
: dia_IOCtrlSignal ( DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED,
                     DIA_EN_IOCTRL_SIGTYPE_IPSIM_PRESSED_KEY,
                     2,
                     DIA_EN_IOCTRL_CTRLMODE_TESTER ),
   bPressDone(FALSE),
   u16KeyCode(0x0000),
   KeyID(DIA_PRJ_KEY_CODE_UNKNOWN)
{
}

//------------------------------------------------------------------------------

dia_IOCtrlInputHdlPressedKeyPrj::~dia_IOCtrlInputHdlPressedKeyPrj ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlInputHdlPressedKeyPrj::~dia_IOCtrlInputHdlPressedKeyPrj !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlInputHdlPressedKeyPrj::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlInputHdlPressedKeyPrj::handleRequest");

   tDiaResult retVal = DIA_SUCCESS;
   bPressDone = FALSE;
   tBool errorDetected = TRUE;

   u16KeyCode = ctrlValue->at(1);
   u16KeyCode = u16KeyCode | tU16(ctrlValue->at(0) << 8);
   dia_IInputHandlingPrj* pInterface = 0;

   KeyID=getInputHandlingKeyCode(u16KeyCode);
   if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
	   if ( KeyID != DIA_PRJ_KEY_CODE_UNKNOWN )
	   {
          (void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
          if ( DIA_SUCCESS == (pInterface->setKeyInternalCode(KeyID ,DIA_EN_PRJ_KEY_INFO_PRESSED)) )
          {
			  errorDetected = FALSE;
          }
	   }
   }
   if(errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR("dia_IOCtrlInputHdlPressedKeyPrj::handleRequest - SEND TO IPSIM FAILED!!!!");
      retVal = DIA_E_CONDITIONS_NOT_CORRECT;
   }
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
   mIsResultReady = FALSE;

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlInputHdlPressedKeyPrj::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKeyPrj::handleTimeout");
   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlInputHdlPressedKeyPrj::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlInputHdlPressedKeyPrj::vOnTerminate()");

   tDiaResult retVal = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE )
      {
         // wait for the response
         mIsResultReady = FALSE;
      }
   }

   eSetStatus(status);

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlInputHdlPressedKeyPrj::vOnSetKey ( const tDiaResult eDiaResult )
{
   dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKeyPrj::vOnSetKey");

   tBool errorDetected = FALSE;
   dia_IInputHandlingPrj* pInterface = 0;
   if ((eDiaResult == DIA_SUCCESS) && ((querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface)) == DIA_SUCCESS) && pInterface)
   {
      if ((!bPressDone) && (KeyID != DIA_PRJ_KEY_CODE_UNKNOWN ))
	  {
         bPressDone = TRUE;
         OSAL_s32ThreadWait(200);

		  if (DIA_SUCCESS == pInterface->setKeyInternalCode(KeyID ,DIA_EN_PRJ_KEY_INFO_RELEASED))
         {
			  DIA_TR_INF("dia_IOCtrl_PressedKey::vOnSetKey - (MODE_PRESSED) SUCCESS.");
         }
	      else
	      {
			 errorDetected = TRUE;
	      }

	   }
	  else
	  {
         mIsResultReady = TRUE;
		(void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		 dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	  }
   }
	else
	{
		errorDetected = TRUE;
	}

    if(errorDetected)
	{
		mIsResultReady = TRUE;
   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	}
 }
//-----------------------------------------------------------------------------

dia_eVdInuptHandlingKeyCodePrj
dia_IOCtrlInputHdlPressedKeyPrj::getInputHandlingKeyCode ( tU16 KeyCode )
 {
	 dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKeyPrj::getInputHandlingKeyCode");
	 KeyID= DIA_PRJ_KEY_CODE_UNKNOWN;
	  switch(u16KeyCode)
	  {
			case DIA_KEYCODE_INPUT_INF4CV_MCP_HOME_COCKPIT:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_HOME_COCKPIT;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_SRC_COCKPIT:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SRC_COCKPIT;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_NAV:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_NAV;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_MAP:
				 KeyID=DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_MAP ;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_SRC_CABIN:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SRC_CABIN;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_HOME_CABIN:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_HOME_CABIN;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_SET_COCKPIT:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SET_COCKPIT;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_CAM:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_CAM;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_PHONE_ACCEPT:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_PHONE_ACCEPT;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_PHONE_REJECT:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_PHONE_REJECT;
				 break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_MON:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_MON;
				 break;
            case DIA_KEYCODE_INPUT_INF4CV_MCP_SET_CABIN:
				 KeyID = DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SET_CABIN;
				 break;
			case DIA_KEYCODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT:
				KeyID = DIA_PRJ_KEY_CODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT;
				break; 
			case DIA_KEYCODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN:
				KeyID = DIA_PRJ_KEY_CODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN;
				break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_POWER:
				KeyID = DIA_PRJ_KEY_CODE_POWER;
				break;
			case DIA_KEYCODE_INPUT_INF4CV_MCP_POWER_LONG:
				KeyID = DIA_PRJ_KEY_CODE_POWER_LONGPRESS;
				break;
			default:
				DIA_TR_INF("No valid value has supplied");
				break;
	}

	 DIA_TR_INF("dia_IOCtrlInputHdlPressedKeyPrj::getInputHandlingKeyCode - Code=0x%x  ,KeyID=0x%x",KeyCode,KeyID);
	 return KeyID;
 }
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlInputHdlPressedKeyPrj::triggerKey ( dia_eInputHandlingKeyInfoPrj /*eKeyInfo */) const
{
	tDiaResult retVal = DIA_FAILED;
	/*dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKeyPrj::triggerKey");


   dia_IInputHandlingPrj* pInterface = 0;

   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         retVal = pInterface->setKeyIntern (u16KeyCode, eKeyInfo);
      }
   }
   */
   return retVal;
}
