/*
 * dia_IOCtrlExtOutSpare3.cpp
 *
 *  Created on: 15.07.2016
 *  Author: dvd5kor
 */

#ifndef DIA_IOCTRL_EXT_OUT_SPARE3_H_
#include "project/services/production/dia_IOCtrlExtOutSpare3.h"
#endif
#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

#define ACTIVATE_SPARE3_EXT_OUT     0x01
#define DEACTIVATE_SPARE3_EXT_OUT   0x00

#define DIA_PROP_GPIO_EXT_OUT_SPARE_SIZE   0x01
//#define INDEX						0
//------------------------------------------------------------------------------

dia_IOCtrlExtOutSpare3::dia_IOCtrlExtOutSpare3 ( void )
   : dia_IOCtrlSignal ("dia_IOCtrlExtOutSpare3",
		   	   	   	   DIA_C_U16_DID_AIVI_EXT_OUT_SPARE3,
		   	   	   	   CTRL_VALUE_SIZE, // Length in Byte
                       DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
                       DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED )
{
}
//------------------------------------------------------------------------------

dia_IOCtrlExtOutSpare3::~dia_IOCtrlExtOutSpare3 ( void )
{
}
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlExtOutSpare3::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlExtOutSpare3::handleRequest()");
   tU8 outputValue = DEACTIVATE_SPARE3_EXT_OUT;
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("dia_IOCtrlExtOutSpare3::handleRequest timerValue=%d, ctrlValue->size()=%d.", timerValue, ctrlValue->size());

   switch(ctrlValue->at(0))
   {
      case 0x00:
         outputValue = DEACTIVATE_SPARE3_EXT_OUT;
         DIA_TR_INF("dia_IOCtrlExtOutSpare3::handleRequest DEACTIVATE ExtOut Spare3 0x%02x.", ctrlValue->at(0));
      break;

      default:
         DIA_TR_INF("dia_IOCtrlExtOutSpare3::handleRequest ACTIVATE ExtOut Spare3 0x%02x !", ctrlValue->at(0));
         outputValue = ACTIVATE_SPARE3_EXT_OUT;
      break;
   }

   mIsResultReady = FALSE;



   // write System Amp On Output
   if (setExtOutput (outputValue) == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_IOCtrlExtOutSpare3::handleRequest setExtOutput SUCCESS");
      mIsResultReady = TRUE;
      dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   }
   else
   {
      DIA_TR_ERR("dia_IOCtrlExtOutSpare3::handleRequest FAILED");
      retCode = DIA_FAILED;
   }

   // NO_ERROR allows the service handler to return immediately
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlExtOutSpare3::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlExtOutSpare3::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }

      // write System Amp On Output
      if (setExtOutput (DEACTIVATE_SPARE3_EXT_OUT) == DIA_SUCCESS)
      {
         mIsResultReady = TRUE;
         DIA_TR_INF("dia_IOCtrlExtOutSpare3::vOnTerminate(): ABLE TO WRITE GPIO data");
      }
      else
      {
         DIA_TR_ERR("dia_IOCtrlExtOutSpare3::vOnTerminate(): UNABLE TO WRITE GPIO data");
      }
   }

   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlExtOutSpare3::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlExtOutSpare3::handleTimeout");
}
//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlExtOutSpare3::setExtOutput ( const tU8 ctrlValue ) const
{
   dia_tclFnctTrace trc("dia_IOCtrlExtOutSpare3::setExtOutput");

   tDiaResult retCode = DIA_SUCCESS;

   tU16 size = dia_getPropertySize(DIA_PROP_GPIO_EXT_OUT_SPARE3);
   tU8 data[DIA_PROP_GPIO_EXT_OUT_SPARE_SIZE] = {0};

   data[0] = ctrlValue;

   // write System Amp On Output
   if (DIA_SUCCESS != dia_setProperty(DIA_PROP_GPIO_EXT_OUT_SPARE3, data, size))
   {
      retCode = DIA_FAILED;
      DIA_TR_INF("dia_IOCtrlExtOutSpare3::setExtOutput(): UNABLE TO WRITE GPIO data");
   }

   return retCode;
}
