/*
 * dia_IOCtrlAudioExtOutTelMode.cpp
 *
 *  Created on: 23.03.2016
 *      Author: kaa1hi
 */

#include "project/services/production/dia_IOCtrlAudioExtOutTelMode.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

#define ACTIVATE_AUDIO_EXT_OUT_TEL_MODE     0x01
#define DEACTIVATE_AUDIO_EXT_OUT_TEL_MODE   0x00

#define DIA_PROP_GPIO_AUDIO_EXT_OUT_TEL_MODE_SIZE   0x01
//------------------------------------------------------------------------------

dia_IOCtrlAudioExtOutTelMode::dia_IOCtrlAudioExtOutTelMode ( void )
   : dia_IOCtrlSignal ("dia_IOCtrlAudioExtOutTelMode", DIA_C_U16_DID_AIVI_AUDIO_EXT_OUT_TEL_MODE, CTRL_VALUE_SIZE, // Length in Byte
                        DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
                        DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED )
{
}
//------------------------------------------------------------------------------

dia_IOCtrlAudioExtOutTelMode::~dia_IOCtrlAudioExtOutTelMode ( void )
{
}
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioExtOutTelMode::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioExtOutTelMode::handleRequest()");
   tU8 outputValue = DEACTIVATE_AUDIO_EXT_OUT_TEL_MODE;
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("dia_IOCtrlAudioExtOutTelMode::handleRequest ctrlValue->size() = %d .", ctrlValue->size());

   switch(ctrlValue->at(0))
   {
      case 0x00:
         outputValue = DEACTIVATE_AUDIO_EXT_OUT_TEL_MODE;
         DIA_TR_INF("dia_IOCtrlAudioExtOutTelMode::handleRequest DEACTIVATE Tel Mode 0x%02x.", ctrlValue->at(0));
      break;

      default:
         DIA_TR_INF("dia_IOCtrlAudioExtOutTelMode::handleRequest ACTIVATE Tel Mode 0x%02x !", ctrlValue->at(0));
         outputValue = ACTIVATE_AUDIO_EXT_OUT_TEL_MODE;
      break;
   }

   mIsResultReady = FALSE;

   // write System Amp On Output
   if (setExtOutput (outputValue) == DIA_SUCCESS)
   {
      mIsResultReady = TRUE;
      dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   }
   else
   {
      retCode = DIA_FAILED;
   }

   // NO_ERROR allows the service handler to return immediately
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioExtOutTelMode::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioExtOutTelMode::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }

      // write System Amp On Output
      if (setExtOutput (DEACTIVATE_AUDIO_EXT_OUT_TEL_MODE) == DIA_SUCCESS)
      {
         mIsResultReady = TRUE;
         DIA_TR_INF("dia_IOCtrlAudioExtOutTelMode::vOnTerminate(): ABLE TO WRITE GPIO data");
      }
      else
      {
         DIA_TR_INF("dia_IOCtrlAudioExtOutTelMode::vOnTerminate(): UNABLE TO WRITE GPIO data");
      }

   }
   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioExtOutTelMode::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioExtOutTelMode::handleTimeout");
}
//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioExtOutTelMode::setExtOutput ( const tU8 ctrlValue ) const
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioExtOutTelMode::setExtOutput");

   tDiaResult retCode = DIA_SUCCESS;

   tU16 size = dia_getPropertySize(DIA_PROP_GPIO_AUDIO_EXT_OUT_TEL_MODE);
   tU8 data[DIA_PROP_GPIO_AUDIO_EXT_OUT_TEL_MODE_SIZE] = {0};

   data[0] = ctrlValue;

   // write System Amp On Output
   if (DIA_SUCCESS != dia_setProperty(DIA_PROP_GPIO_AUDIO_EXT_OUT_TEL_MODE, data, size))
   {
      retCode = DIA_FAILED;
      DIA_TR_INF("dia_IOCtrlAudioExtOutTelMode::setExtOutput(): UNABLE TO WRITE GPIO data");
   }

   return retCode;
}
