/************************************************************************
* FILE:           dia_SrvHandler_GenericVinOdometerWrite.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    This file contains the definition of dia_SrvHandler_GenericVinOdometerWrite class,
*				  that provides a service handler which ca nbe used to process  
*                 diagnostic write requests for VIN Odometer Write & VIN Odometer Limit Write.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 21.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_SERVICE_HANDLER_VIN_ODOMETER_GENERIC_WRITE__
#include "project/services/customer/vin/dia_SrvHandler_GenericVinOdometerWrite.h"
#endif

#ifndef __INCLUDED_DIA_VINODOMETERHANDLER__
#include "project/framework/vin/dia_Odometer.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_VIN__
#include "project/framework/vin/dia_defsVinConfig.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#define DIA_U16_WRITE_DATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))
#define DIA_U16_ODOMETER_DATA_LENGTH  ((tU16) (1))
#define DIA_U16_ODOMETER_MAX_RANGE    ((tU16) 0xFA)
#define MSG_DATA_OFFSET 4
#define DIA_U16_REPLY_LENGTH   ((tU16) (1 /* SID */ + 2 /* DID */))

using namespace dia;

//------------------------------------------------------------------------------

dia_SrvHandler_GenericVinOdometerWrite::dia_SrvHandler_GenericVinOdometerWrite ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER, did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_GenericVinOdometerWrite::dia_SrvHandler_GenericVinOdometerWrite(tCString,tU8,tU16)");
}

//------------------------------------------------------------------------------

dia_SrvHandler_GenericVinOdometerWrite::~dia_SrvHandler_GenericVinOdometerWrite ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandler_GenericVinOdometerWrite::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GenericVinOdometerWrite::vProcessRequest(...)");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_WRITE_DATA_BY_ID_REQUEST_LENGTH + DIA_U16_ODOMETER_DATA_LENGTH + 1) ) // one additional byte contains the message length
   {
		DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite::vProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DIA_U16_WRITE_DATA_BY_ID_REQUEST_LENGTH+DIA_U16_ODOMETER_DATA_LENGTH+1), dataLength);
		vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
		return;
   }
   
   if ( !(vecArgs.size()) )
   {
		// Sending back the Negative answer
		DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite: FAILED (Property Not Available) !!");
		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
		return;
   }

   dia_Odometer* pOdometerHandler = getInstanceOfOdometerHandler();
   if(pOdometerHandler)
   {
      if (ODOMETER_LOCKED == pOdometerHandler->isOdometerLocked())
      {
         DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite::vProcessRequest - Odometer is locked. ");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }
   }
   
   tU32 propID = VoidCast<tU32>(vecArgs[0]);
   tU16 propLength = dia_getPropertySize(propID);
   // initialize the data buffer
   tU8 u8propData[propLength] = {0};
   (void) ::memset(u8propData,0,propLength);
   
   // copy until end of msg. (max ms length == 240B) or '\0' (0x0)
   tU16 u16EleCount = 0;
   for ( ; u16EleCount < DIA_U16_ODOMETER_DATA_LENGTH; u16EleCount++)
   {
      if ( u16EleCount < DIA_PROP_LENGTH_MAX ) 
	  {
         u8propData[u16EleCount] = pU8[u16EleCount+MSG_DATA_OFFSET];
		 DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite::odoData[%d] = 0x%02x", u16EleCount, u8propData[u16EleCount]);
      }
   }


   //! handling the odometer counter 
   if(DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER == propID)
   {
      tU8 OdometerLimit = 0;
      if(DIA_SUCCESS != pOdometerHandler->getOdometerLimit(&OdometerLimit))
      {
         DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite::vProcessRequest - Odometer limit read failed. ");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }

      if (u8propData[0] == OdometerLimit)
      {
         if(DIA_SUCCESS != pOdometerHandler->lockOdometer())
         {
            DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite::vProcessRequest - Odometer locking failed. ");
            vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
            return;
         }
      }

      if(u8propData[0] > OdometerLimit)
      {
         // Sending back the Negative answer
         DIA_TR_ERR("dia_SrvHandler_GenericVinOdometerWrite: Input Value Out of Range !!");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }
   }
   //! handling the odometer limit
   else
   {

      //! checking for the range
      if(u8propData[0] > DIA_U16_ODOMETER_MAX_RANGE)
      {
      	// Sending back the Negative answer
	  	   DIA_TR_ERR("dia_SrvHandler_GenericVinOdometerWrite: Input Value Out of Range !!");
	  	   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }

      tU8 OdometerCounter = 0;
      if(DIA_SUCCESS != pOdometerHandler->getOdometerCounter(&OdometerCounter))
      {
         DIA_TR_ERR("dia_SrvHandler_GenericVinOdometerWrite: Reading Odometer Counter Failed !!");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }

      if(u8propData[0] <= OdometerCounter)
      {
         DIA_TR_ERR("dia_SrvHandler_GenericVinOdometerWrite: Odometer Limit is lessar than current Counter !!");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }
   }


   //! Write the property into KDS as all conditions have passed now

   if(DIA_SUCCESS == dia_setProperty ( propID, u8propData, propLength ))
   {

      DIA_TR_INF("dia_SrvHandler_GenericVinOdometerWrite:: Write Succeeded !!");
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DIA_U16_REPLY_LENGTH);
      vResReadyAndQuit();
   }
   else
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandler_GenericVinOdometerWrite:: Write Failed !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }
   
}
