/************************************************************************
* FILE:         dia_tclUDS_WIFI_CustMacAddress.h
* PROJECT:      DIAG Core
* SW-COMPONENT: Diagnostic application
*
*  Created on: 14.01.2016
*      Author: nce5kor
*------------------------------------------------------------------------
* Date 	    | Author	          | Modification
*************************************************************************/


#ifndef dia_tclUDS_WIFI_CustMacAddress_H
#define dia_tclUDS_WIFI_CustMacAddress_H

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include <project/interfaces/dia_IBluetoothListener.h>
#endif

class dia_tclUDS_WIFI_CustMacAddress : public dia_ServiceHandlerUDS,
                                    public dia_IBluetoothListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_tclUDS_WIFI_CustMacAddress);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_tclUDS_WIFI_CustMacAddress);

 public:
   //! class constructor
   dia_tclUDS_WIFI_CustMacAddress ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_tclUDS_WIFI_CustMacAddress(void);

   //! method called to start service processing
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   //! Request Handler Function
   virtual void vOnReadCustWifiMacAddressResult( const tU8* const pu8Result );

   //! Response Handler Function Error
   virtual void vOnReadCustWifiMacAddressError(const tU32 errCode );
};


#endif

