/************************************************************************
* FILE:         dia_tclUDS_WIFI_CustMacAddress.cpp
* PROJECT:      DIAG Core
* SW-COMPONENT: Diagnostic application
*
*  Created on: 14.01.2016
*      Author: nce5kor
*------------------------------------------------------------------------
* Date 	    | Author	          | Modification
*************************************************************************/

#include "dia_tclUDS_WIFI_CustMacAddress.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#define DATA_START            (1/*sizeof(SID)*/ + mDIDLen)
#define DATA_LENGTH           (6U)    //string length "AA:BB:CC:DD:EE:FF"
#define DIA_MAC_ADDRESS_LEN   (6U)

//-------------------------------------------------------------------------------

dia_tclUDS_WIFI_CustMacAddress::dia_tclUDS_WIFI_CustMacAddress(tCString name, tU8 sid, tU16 did):
      dia_ServiceHandlerUDS(name,sid,(tU16) did)
{
   dia_tclFnctTrace trc("dia_tclUDS_WIFI_CustMacAddress::dia_tclUDS_WIFI_CustMacAddress");
}

//-------------------------------------------------------------------------------

dia_tclUDS_WIFI_CustMacAddress::~dia_tclUDS_WIFI_CustMacAddress()
{
   _BP_TRY_BEGIN
   {
     (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia_tclUDS_WIFI_CustMacAddress::~dia_tclUDS_WIFI_CustMacAddress - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_tclUDS_WIFI_CustMacAddress::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_tclUDS_WIFI_CustMacAddress::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IBluetooth* pIBluetooth = 0;
   tDiaResult sysAdapterResult = querySysAdapterInterface<dia_IBluetooth>(&pIBluetooth);

   if ((DIA_SUCCESS==sysAdapterResult) && pIBluetooth)
   {
      (void) setSysAdapterListener<dia_IBluetoothListener>(this);
      if ( pIBluetooth->vGetWifiMacAddress() != DIA_SUCCESS )
      {
         DIA_TR_ERR("!!! dia_tclUDS_WIFI_CustMacAddress::vProcessRequest => ERROR: vGetWifiMacAddress != DIA_SUCCESS");
      }
      else
      {
         errorDetected = FALSE;
         DIA_TR_INF("dia_tclUDS_WIFI_CustMacAddress::vProcessRequest => Send Successfully to Server");
      }
   }
   else
   {
      DIA_TR_INF("!!! dia_tclUDS_WIFI_CustMacAddress::vProcessRequest ERROR: sysAdapterResult=0x%X pIBluetooth=0x%p", sysAdapterResult, pIBluetooth);
   }

   if ( errorDetected )
   {
      DIA_TR_INF("dia_tclUDS_WIFI_CustMacAddress::vProcessRequest => ERROR DETECTED");
      (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-------------------------------------------------------------------------------

void
dia_tclUDS_WIFI_CustMacAddress::vOnReadCustWifiMacAddressResult(const tU8* const pu8Result)
{
   dia_tclFnctTrace trc("dia_tclUDS_WIFI_CustMacAddress::vOnReadCustWifiMacAddressResult");

   (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   for(tU8 i=0; i < DIA_MAC_ADDRESS_LEN; i++)
   {
	   oDiagMsgBuffer().vSetDataU8(DATA_START + i, pu8Result[i]);
   }

   vResReadyAndQuit();
   DIA_TR_INF("dia_tclUDS_WIFI_CustMacAddress::vOnReadCustWifiMacAddressResult MAC %02X:%02X:%02X:%02X:%02X:%02X",
               pu8Result[0], pu8Result[1], pu8Result[2], pu8Result[3], pu8Result[4], pu8Result[5]);
}

//-------------------------------------------------------------------------------

void
dia_tclUDS_WIFI_CustMacAddress::vOnReadCustWifiMacAddressError (const tU32 errCode )
{
   dia_tclFnctTrace trc("dia_tclUDS_WIFI_CustMacAddress::vOnReadCustWifiMacAddressError");

   (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   DIA_TR_INF( "dia_tclUDS_WIFI_CustMacAddress::vOnReadCustWifiMacAddressError=> errCode=%08X",errCode);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}
