/*!
* \file       dia_Srvhandler_RadioState_Get.h
*
* \brief      Radio State of the system
*
* \details    Class dia_Srvhandler_RadioState_Get returns the state of SPM system
*
* \component  Diagnosis
*
* \ingroup    SPM
*
* \copyright  (c) 2016-2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef DIA_SRVHANDLER_RADIOSTATE_GET_H_
#define DIA_SRVHANDLER_RADIOSTATE_GET_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_Srvhandler_RadioState_Get
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_Srvhandler_RadioState_Get);


public:
   //! class constructor
      dia_Srvhandler_RadioState_Get ( void );

   /**
     * \brief  handle the received request
     *         Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *         The SystemAdapter returns the reset history.
     */
   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested radio state
     *            Function receives the message via its parameter and send it to the tester.
     *            It verifies the SA answer and send the radio state to the tester.
     * \param[in]	dia_eSpmSystemState , dia_eSpmSystemState
     */
   virtual void vOnRadioState ( dia_eSpmSystemState );

protected:
   //! class destructor
   virtual ~dia_Srvhandler_RadioState_Get(void);

};

#endif /* DIA_SRVHANDLER_RADIOSTATE_GET_H_ */
