/*!
* \file       dia_Srvhandler_RadioState_Get.cpp
*
* \brief      Radio State of the system
*
* \details    Class dia_Srvhandler_RadioState_Get returns the state of SPM system
*
* \component  Diagnosis
*
* \ingroup    SPM
*
* \copyright  (c) 2016-2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

// TTFis: DIA_REQ UDS 04 22 10 05
#ifndef DIA_SRVHANDLER_RADIOSTATE_GET_H_
#include "project/services/customer/dia_Srvhandler_RadioState_Get.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 				3
#define DATA_LENGTH 			1
#define RAD_STATE_ON 			0x01
#define RAD_STATE_OFF			0x00

static tCString arRadiostatemapping[] = {
   "DIA_EN_RADIO_STATE_UNKNOWN",
   "DIA_EN_RADIO_STATE_SUSPEND",
   "DIA_EN_RADIO_STATE_STANDBY",
   "DIA_EN_RADIO_STATE_OFF",
   "DIA_EN_RADIO_STATE_DOWNLOAD",
   "DIA_EN_RADIO_STATE_ON",
   "DIA_EN_RADIO_STATE_BACKGROUND",
   "DIA_EN_RADIO_STATE_DOOR_OPEN",
   "DIA_EN_RADIO_STATE_IGNITION",
   "DIA_EN_RADIO_STATE_DIAGNOSIS",
   "DIA_EN_RADIO_STATE_PROFILE",
   "DIA_EN_RADIO_STATE_PREPARE_SHUTDOWN",
   "DIA_EN_RADIO_STATE_SHUTDOWN",
   "DIA_EN_RADIO_STATE_MMI_STANDBY_PWR_SAVE_1",
   "DIA_EN_RADIO_STATE_MMI_STANDBY_PWR_SAVE_2",
   "DIA_EN_RADIO_STATE_MMI_STANDBY",
   "DIA_EN_RADIO_STATE_MMI_ON",
   "DIA_EN_RADIO_STATE_MMI_STANDBY_RESTRICTED",
   "DIA_EN_RADIO_STATE_MMI_ON_DIAG",
   "DIA_EN_RADIO_STATE_MMI_ON_TEL",
   "DIA_EN_RADIO_STATE_MMI_ON_SWDL",
   "DIA_EN_RADIO_STATE_MMI_STANDBY_CUSTOMER_SWDL",
   "DIA_EN_RADIO_STATE_MMI_STANDBY_PWR_SAVE",
   "DIA_EN_RADIO_STATE_OVERTEMP",
   "DIA_EN_RADIO_STATE_SAFE",
   "DIA_EN_RADIO_STATE_STATE_MAX",
   "DIA_EN_RADIO_STATE_COUNT"
};

//-----------------------------------------------------------------------------

dia_Srvhandler_RadioState_Get::dia_Srvhandler_RadioState_Get(void) :
      dia_ServiceHandlerUDS("dia_Srvhandler_RadioState_Get", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_RADIO_STATE /*DID*/)
{
   dia_tclFnctTrace trc("dia_Srvhandler_RadioState_Get::dia_Srvhandler_RadioState_Get(void)");
}

//-----------------------------------------------------------------------------

dia_Srvhandler_RadioState_Get::~dia_Srvhandler_RadioState_Get(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_Srvhandler_RadioState_Get::~dia_Srvhandler_RadioState_Get !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }

   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void dia_Srvhandler_RadioState_Get::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_Srvhandler_RadioState_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS)
   {
      if (pSpm)
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getRadioState() == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
      }
      else
      {
         DIA_TR_ERR("dia_Srvhandler_RadioState_Get::vProcessRequest pSpm NULL");
      }
   }
   else
   {
      DIA_TR_ERR("dia_Srvhandler_RadioState_Get::vProcessRequest querySysAdapterInterface FAILED");
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_Srvhandler_RadioState_Get ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void dia_Srvhandler_RadioState_Get::vOnRadioState(dia_eSpmSystemState state)
{
   dia_tclFnctTrace trc("dia_Srvhandler_RadioState_Get::vOnRadioState");

   oDiagMsgBuffer().vSetPosResp();
   // Sending back the positive answer
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   DIA_TR_INF("state received = %d",state);
      if(0 == strcmp(arRadiostatemapping[state],"DIA_EN_RADIO_STATE_ON"))//Coverity fix (CID - 46597)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START , RAD_STATE_ON);
         DIA_TR_INF("dia_Srvhandler_RadioState_Get::vOnRadioState is ON");
      }
      else
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START, RAD_STATE_OFF);
         DIA_TR_INF("dia_Srvhandler_RadioState_Get::vOnRadioState is OFF");
      }

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
}
