/*!
 * \file       dia_SrvHandler_WriteFactoryMode.h
 *
 * \brief      Service Handler for Factory Mode Writing
 *
 * \details    
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef DIA_SRV_HANDLER_WRITE_FACTORY_MODE_H_
#define DIA_SRV_HANDLER_WRITE_FACTORY_MODE_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef dia_SrvHandlerGenericIdentWrite_H_
#include "common/services/uds/generic/dia_SrvHandlerGenericIdentWrite.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif


class dia_SrvHandler_WriteFactoryMode
   : public dia_SrvHandlerGenericIdentWrite,
     public dia_IErrorLogListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_WriteFactoryMode);

public:
   //! class constructor
   dia_SrvHandler_WriteFactoryMode(tCString name, tU8 sid, tU16 did, tU32 PropID);

   //! class destructor
   virtual ~dia_SrvHandler_WriteFactoryMode(void);

   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IErrorLogListenerImpl methods
   //
   //-------------------------------------------------------------------------

   //! positive response on clearing the fault memory
   virtual void vOnClearResult();
   //! negative response on clearing the fault memory
   virtual void vOnClearError(tU32 u32Error);

};

#endif /* DIA_SRV_HANDLER_WRITE_FACTORY_MODE_H_ */
