/*
 * dia_SrvHandler_TouchPress.cpp
 *
 *  Created on: 23.10.2015
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 03 22 03 06

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_SRVHANDLER_TOUCH_PRESS_H_
#include "dia_SrvHandler_TouchPress.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif

#define DATA_START 3
#define DATA_COORDINATE_X_START   4
#define DATA_COORDINATE_Y_START   6
#define DATA_LENGTH 5

//-----------------------------------------------------------------------------

dia_SrvHandler_TouchPress::dia_SrvHandler_TouchPress ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TouchPress",
     DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
     (tU16) DIA_C_U16_DID_AIVI_TOUCH_PRESS /*DID*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TouchPress::dia_SrvHandler_TouchPress(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TouchPress::~dia_SrvHandler_TouchPress ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TouchPress::~dia_SrvHandler_TouchPress !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_TouchPress::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TouchPress::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandlingPrj* pInterface = 0;
   if ( querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS )
   {
        DIA_TR_INF("dia_SrvHandler_TouchPress::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
         if ( pInterface->getTouchInfo () == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
       else
       {
            DIA_TR_INF("dia_SrvHandler_TouchPress::vProcessRequest - getTouchInfo() failed.");
         }
      }
   }
   else
   {
        DIA_TR_INF("dia_SrvHandler_TouchPress::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
      DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_TouchPress::vOnTouchInfo ( const tU16 u16X, const tU16 u16Y,
      const tU16 /*u16DeltaX*/, const tU16 /*u16DeltaY*/, const dia_eInputHandlingTouchInfoPrj eTouchInfo )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TouchPress:vOnTouchInfo()");

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   tU8 u8Touch = 0;  //not pressed
   if (eTouchInfo == DIA_EN_PRJ_TOUCH_INFO_TOUCHED)
   {
      DIA_TR_INF("dia_SrvHandler_TouchPress:vOnTouchInfo() eTouchInfo is DIA_EN_PRJ_TOUCH_INFO_TOUCHED");
      u8Touch |= (1UL << 0);
   }

   (void) oDiagMsgBuffer().vSetDataU8(DATA_START, u8Touch);

   // x
   (void) oDiagMsgBuffer().vSetDataU8(DATA_COORDINATE_X_START,     (tU8) (u16X >> 8));
   (void) oDiagMsgBuffer().vSetDataU8(DATA_COORDINATE_X_START + 1, (tU8) u16X);
   // y
   (void) oDiagMsgBuffer().vSetDataU8(DATA_COORDINATE_Y_START,     (tU8) (u16Y >> 8));
   (void) oDiagMsgBuffer().vSetDataU8(DATA_COORDINATE_Y_START + 1, (tU8) u16Y);

   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);

   vResReadyAndQuit();
}

//--------------------------------------------------------------------------------------------

void
dia_SrvHandler_TouchPress::vOnTouchInfoError( void )
{
   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
   DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}
