/*
 * dia_SrvHandler_SupportedIdentifiers.h
 *
 *  Created on: 12.01.2016
 *      Author: shw2abt
 */
//TTFis: DIA_REQ UDS 04 22 DF DF --> Read high Bytes
//TTFis: DIA_REQ UDS 04 22 DF xx --> Read low Bytes of high Byte xx

#ifndef DIA_SRVHANDLER_SUPPORTED_IDENTIFIERS_H_
#define DIA_SRVHANDLER_SUPPORTED_IDENTIFIERS_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

#include "project/framework/config/dia_EngineConfigGen3g.h"

class dia_SrvHandler_SupportedIdentifiers
   : public dia_ServiceHandlerUDS
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_SupportedIdentifiers);

public:
   //! class constructor
   dia_SrvHandler_SupportedIdentifiers( tCString name, tU8 sid );

   //! called to request the lookup keys for this service
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

   virtual void vProcessRequest ( const std::vector<void*>& /*vecArgs*/ );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_SupportedIdentifiers(void);
   //! add services which are handled directly on V850 and doesn't appear in our iMx repositories
   tDiaResult addV850ServicesToSupportedIdentifiers(const dia_Session* session, tU8 service, std::vector<tU8>& supportedIdents, tU16 bitMask=0xFFFF) const;

};

#endif /* DIA_SRVHANDLER_SUPPORTED_IDENTIFIERS_H_ */
