/*
 * dia_SrvHandler_SpeedInformationAIVI.cpp
 *
 *  Created on: 30.11.2017
 *      Author:
 */
// TTFis:\> DIA_REQ UDS 03 22 02 01

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_SpeedInformationAIVI.h"

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_SpeedInformationAIVI::dia_SrvHandler_SpeedInformationAIVI ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_SpeedInformationAIVI", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_SPEED_INFO)
{
   dia_tclFnctTrace trc("dia_SrvHandler_SpeedInformationAIVI::dia_SrvHandler_SpeedInformationAIVI(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_SpeedInformationAIVI::~dia_SrvHandler_SpeedInformationAIVI ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ISensorSpeedListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_SpeedInformationAIVI::~dia_SrvHandler_SpeedInformationAIVI !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_SpeedInformationAIVI::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_SpeedInformationAIVI::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISensorSpeed* pInterface = 0;
   if (querySysAdapterInterface<dia_ISensorSpeed>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (void) setSysAdapterListener<dia_ISensorSpeedListener>(this);
         if (pInterface->getSensorSpeed() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_SpeedInformationAIVI::vProcessRequest - getSensorSpeed() failed.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_SpeedInformationAIVI::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ISensorSpeedListener>(this);
      DIA_TR_ERR("dia_SrvHandler_SpeedInformationAIVI ---  SEND TO SensorPV SERVER FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_SpeedInformationAIVI::vOnSensorSpeed (tU16 speed)
{
   dia_tclFnctTrace trc("dia_SrvHandler_SpeedInformationAIVI::vOnSensorSpeed");
   DIA_TR_INF("dia_SrvHandler_SpeedInformationAIVI::vOnSensorSpeed speed received: %d, 0x%04x .", speed, speed);

   if(speed!=SENSOR_SPEED_INVALID){
      (void) unsetSysAdapterListener<dia_ISensorSpeedListener>(this);
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      //CAN multiple factor 100 for all CAN Signals.
      /* // phys = 0.01 * data
      speed = static_cast<tU16>(speed * 100);
      DIA_TR_INF("dia_SrvHandler_SpeedInformationAIVI::vOnSensorSpeed recalculated speed acc.CDD : %d, 0x%04x .", speed, speed);*/

      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 0, ((tU8) (speed >> 8)));
      (void) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + 1, (((tU8) speed)));

      vResReadyAndQuit();
   } else {
      (void) unsetSysAdapterListener<dia_ISensorSpeedListener>(this);
      DIA_TR_ERR("dia_SrvHandler_SpeedInformation::vOnSensorSpeed Speed Signal INVALID/UNAVAILABLE !");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
