 /*
 * \file        dia_SrvHandler_ReadVehicleTimeDomainData.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details    
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */


#include "project/services/customer/dia_SrvHandler_ReadVehicleTimeDomainData.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include <project/framework/sigma/dia_Sigma.h>
#endif

//-----------------------------------------------------------------------------
dia_SrvHandler_ReadVehicleTimeDomainData::dia_SrvHandler_ReadVehicleTimeDomainData()
   : dia_ServiceHandlerUDS("dia_SrvHandler_ReadVehicleTimeDomainData")
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleTimeDomainData::dia_SrvHandler_ReadVehicleTimeDomainData()");
}

//-----------------------------------------------------------------------------
dia_SrvHandler_ReadVehicleTimeDomainData::~dia_SrvHandler_ReadVehicleTimeDomainData( void )
{
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadVehicleTimeDomainData::vProcessRequest ( const std::vector<void*>&  )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleTimeDomainData::vProcessRequest");
   const tU16 DATA_START = 3;

   // get DID
   tU16 did = oDiagMsgBuffer().u16GetSubServiceId();
   DIA_TR_INF("dia_SrvHandler_ReadVehicleTimeDomainData::did: 0x%02x", did);
   dia_Sigma* pSigma = dia_Sigma::getInstance();

   std::vector<tU8> sigmaData;
   if(pSigma && pSigma->getData(did, sigmaData))
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(static_cast<tU16>((DATA_START + sigmaData.size()) & 0xffff));
      for (std::vector<tU8>::size_type i = 0; i < sigmaData.size(); ++i) 
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>((DATA_START+i) & 0xffff), sigmaData[i]);
      }
      vResReadyAndQuit();

   }
   else
   { // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_ReadVehicleTimeDomainData::ReadDataByIdentifier FAIL <--------------");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   
   return;
}

tDiaResult
dia_SrvHandler_ReadVehicleTimeDomainData::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleTimeDomainData::makeLookupKeys");
#endif

   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_01, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_02, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_03, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_04, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_05, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_06, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_07, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_08, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_09, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_10, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_11, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_12, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_13, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_14, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_15, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_16, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_17, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_18, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_19, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_20, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_21, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_22, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_23, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_24, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_25, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_26, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_27, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_28, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_29, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_30, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_31, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   keys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_32, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) ); 
   return DIA_SUCCESS;
}

