/*
 * dia_SrvHandler_ReadVehicleIdentifier.cpp
 *
 *  Created on: Nov 23, 2016
 *      Author: OGM5KOR
 */
// TTFis: DIA_REQ UDS 04 22 10 00
#include "project/services/customer/dia_SrvHandler_ReadVehicleIdentifier.h"

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 4

#define ZERO 0
#define ONE 1
#define TWO 2
#define THREE 3



//-----------------------------------------------------------------------------

dia_SrvHandler_ReadVehicleIdentifier::dia_SrvHandler_ReadVehicleIdentifier(tVoid) :
      dia_ServiceHandlerUDS("dia_SrvHandler_ReadVehicleIdentifier", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_VEHICLE_ID_VALUE /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleIdentifier::dia_SrvHandler_ReadVehicleIdentifier(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadVehicleIdentifier::~dia_SrvHandler_ReadVehicleIdentifier(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadVehicleIdentifier::~dia_SrvHandler_ReadVehicleIdentifier !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-------------------------------------------------------------------------------

tVoid dia_SrvHandler_ReadVehicleIdentifier::vProcessRequest(const std::vector<tVoid*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleIdentifier::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getVehicleIdentifierValue() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_ReadVehicleIdentifier ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

void dia_SrvHandler_ReadVehicleIdentifier::vOnGetVehicleIdentifierValue (tU32 veh_id)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadVehicleIdentifier::vOnGetVehicleIdentifierValue");

   DIA_TR_INF("dia_SrvHandler_ReadVehicleIdentifier::vOnGetVehicleIdentifierValue SUCCESSFUL");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   // Sending back the positive answer
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + ZERO,U32_BYTE1(veh_id));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + ONE,U32_BYTE2(veh_id));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + TWO,U32_BYTE3(veh_id));
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START + THREE,U32_BYTE4(veh_id));
   

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_ReadVehicleIdentifier::vOnGetVehicleIdentifierValue SUCCESSFUL");
}
