/*
 * dia_SrvHandler_ReadSecurityFingerprint.cpp
 *
 *  Created on: 29.08.2015
 *      Author: stc2hi
 */
// TTFis:\> DIA_REQ UDS 04 22 F0 10

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif
#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif
#ifndef __DIA_SRVHANDLER_READSECURITYFINGERPRINT_H__
#include "dia_SrvHandler_ReadSecurityFingerprint.h"
#endif

#define DATA_START  3
#define DATA_LENGTH 16

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadSecurityFingerprint::dia_SrvHandler_ReadSecurityFingerprint ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadSecurityFingerprint",
          DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
          DIA_C_U16_DID_AIVI_SECURITY_FINGERPRINT )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadSecurityFingerprint::dia_SrvHandler_ReadSecurityFingerprint(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadSecurityFingerprint::~dia_SrvHandler_ReadSecurityFingerprint ( void )
{
    // no try/catch necessary
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadSecurityFingerprint::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadSecurityFingerprint::vProcessRequest");

   tBool errorDetected = FALSE;
   std::vector<tU8> fingerPrint;

   if (dia_getPropertySize(DIA_PROP_AIVI_SECURITY_FINGERPRINT) == DATA_LENGTH)
   {
      if (DIA_SUCCESS != dia_getProperty(DIA_PROP_AIVI_SECURITY_FINGERPRINT, fingerPrint))
      {
         // if the KDS content isn't available "                " shall be returned.
         DIA_TR_INF("dia_SrvHandler_ReadSecurityFingerprint:: fingerprint empty - set default.");

         fingerPrint.clear();
         for (int i = 0; i < DATA_LENGTH; i++) fingerPrint.push_back(' ');
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadSecurityFingerprint:: fingerprint size ERROR IS=%d, Expected=%d !",
            dia_getPropertySize(DIA_PROP_AIVI_SECURITY_FINGERPRINT), DATA_LENGTH);
      errorDetected = TRUE;
   }

   if ( errorDetected == TRUE )
   {
      DIA_TR_ERR("dia_SrvHandler_ReadSecurityFingerprint::vProcessRequest --- READING PROPERTY FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_ReadSecurityFingerprint::vProcessRequest - Data ready to send.");
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      for (tU16 i=0; i < DATA_LENGTH; i++)
      {
         (void) oDiagMsgBuffer().vSetDataU8(DATA_START + i, fingerPrint[i]);
      }

      vResReadyAndQuit();
   }
}
