/*
 * dia_SrvHandler_ReadMileageValue.cpp
 *
 *  Created on: 19.11.2015
 *      Author: gpu2kor
 */
// TTFis: DIA_REQ UDS 04 22 F0 D0

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef DIA_SRVHANDLER_READ_MILEAGEVALUE_H_
#include "project/services/customer/dia_SrvHandler_ReadMileageValue.h"
#endif

#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"

#define DATA_START  3
#define DATA_LENGTH 3
//-----------------------------------------------------------------------------

dia_SrvHandler_ReadMileageValue::dia_SrvHandler_ReadMileageValue(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_ReadMileageValue", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_MILEAGE_VALUE),
     m_pCsmAccessUser(NULL)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadMileageValue::dia_SrvHandler_ReadMileageValue(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadMileageValue::~dia_SrvHandler_ReadMileageValue(void)
{
   _BP_TRY_BEGIN
   {
      if(m_pCsmAccessUser)
     {
         delete m_pCsmAccessUser;
         m_pCsmAccessUser = NULL;
      }
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadMileageValue::~dia_SrvHandler_ReadMileageValue !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadMileageValue::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadMileageValue::vProcessRequest");

   tBool errorDetected = FALSE;

   if (!m_pCsmAccessUser)
   {
      // create the CSM_Proxy Class
      m_pCsmAccessUser = new csm_tclCsmAccessUser();
      if(m_pCsmAccessUser != NULL)
      {
         // register with CSM_Proxy
         m_pCsmAccessUser->vApplCallbackPreInit();
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandler_ReadMileageValue ---  creation of CSM_proxy object failed!!!");
         errorDetected = TRUE;
      }
   }

   if (!errorDetected)
   {
      getMileage();
   }
   else
   {
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_ReadMileageValue::getMileage()
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadMileageValue::getMileage");
   
//Task 239541
#if 0
   tS32 s32RetVal;
   tU8  signalData[4] = {0,0,0,0};
   tU32 signalStatus = 0;
   tU8 size;
   tBool errorRead = TRUE;

   if(m_pCsmAccessUser != NULL)
   {
       // first check if we receive mileage for CAN GEn5
       size = 4;
       s32RetVal = m_pCsmAccessUser->s32SignalRead( CSM_C_ASIG_RX_DistanceTotalizer, (void*)&signalData[0], size, &signalStatus );
       DIA_TR_INF("--- dia_SrvHandler_ReadMileageValue::getMileage => Return=%d, Status=0x%02x", s32RetVal,signalStatus );
       if((s32RetVal == 0)
          &&(((signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) == CSM_C_SIGNAL_ARRIVED_FIRST)
             ||((signalStatus & CSM_C_SIGNAL_ARRIVED) == CSM_C_SIGNAL_ARRIVED) && ((signalStatus & CSM_C_SIGNAL_TIMEOUT) != CSM_C_SIGNAL_TIMEOUT)
            )
         )
       {
           DIA_TR_INF(("--- dia_SrvHandler_ReadMileageValue::getMileage => CSM_C_ASIG_RX_DistanceTotalizer"));
           DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage DistanceTotalizer: %s", (0!=(signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) ? "CSM_C_SIGNAL_ARRIVED_FIRST is set" : "CSM_C_SIGNAL_ARRIVED_FIRST is NOT set."));
           DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage DistanceTotalizer: %s", (0!=(signalStatus & CSM_C_SIGNAL_ARRIVED)       ? "CSM_C_SIGNAL_ARRIVED is set"       : "CSM_C_SIGNAL_ARRIVED is NOT set."));
           for(int i=0; i<size; i++)
           {
               DIA_TR_INF("Data[%d]: 0x%02X", i, signalData[i]);
           }

           // signal valid
           tU32 mileage = (((tU32)signalData[3]<< 24) + ((tU32)signalData[2]<< 16) + ((tU32)signalData[1]<< 8) + (tU32)signalData[0]) / 100U; // received resolution 0.01

           // now get the unit
           size = 1;
           signalStatus = 0;
           s32RetVal = m_pCsmAccessUser->s32SignalRead( CSM_C_ASIG_RX_DistanceUnit, (void*)&signalData[0], size, &signalStatus );
           DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage => s32RetVal=0x%08X, signalStatus=0x%02X.", s32RetVal, signalStatus);
           if((s32RetVal == 0)
              &&(((signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) == CSM_C_SIGNAL_ARRIVED_FIRST)
                 ||((signalStatus & CSM_C_SIGNAL_ARRIVED) == CSM_C_SIGNAL_ARRIVED)
                )
             )
           {
              DIA_TR_INF("--- dia_SrvHandler_ReadMileageValue::getMileage => UNIT: 0x%02X.",signalData[0]);
              if(signalData[0]==0)
              {
                 DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage unit is km (do nothing).");
              }
              else
              {
                 DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage unit is mile. Convert it to km.");
                 //convert mile-to-km and round to the nearest integral
                 mileage = (tU32)(((float)mileage)*DIAG_MILE_TO_KM_CONV_RATIO + 0.5f); //lint !e524: prio2: Loss of precision (assignment) (double to unsigned long)
              }

              DIA_TR_INF("--- dia_SrvHandler_ReadMileageValue::getMileage => m_mileage: %d (0x%08X) km.", mileage, mileage);

              //call response function
              sendPosResp(mileage);
              errorRead = FALSE;
           }
           else
           {
              // this may happen for CAN C1A and T4VS (NCG3D-41424)
              DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage CSM_C_ASIG_RX_DistanceUnit is not available. Assume km as unit.");
              DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage DistanceUnit: %s", (0!=(signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) ? "CSM_C_SIGNAL_ARRIVED_FIRST is set" : "CSM_C_SIGNAL_ARRIVED_FIRST is NOT set."));
              DIA_TR_INF("dia_SrvHandler_ReadMileageValue::getMileage DistanceUnit: %s", (0!=(signalStatus & CSM_C_SIGNAL_ARRIVED)       ? "CSM_C_SIGNAL_ARRIVED is set"       : "CSM_C_SIGNAL_ARRIVED is NOT set."));

              if (s32RetVal == 0)
              {
                 sendPosResp(mileage);
                 errorRead = FALSE;
              }
              else
              {
                 DIA_TR_ERR("!!! --- dia_SrvHandler_ReadMileageValue::get unit => signal read error: %d", s32RetVal);
                 NORMAL_M_ASSERT_ALWAYS();
              }
           }
       }
       else
       {
           // signal invalid
           DIA_TR_ERR("!!! dia_SrvHandler_ReadMileageValue::getMileage => s32RetVal: 0x%08X", s32RetVal);
       }

      //if there was an error in reading send an invalid value 0xFFFF
      if (errorRead == TRUE)
      {
         DIA_TR_ERR("--- dia_SrvHandler_ReadMileageValue::getMileage => read error, send invalid value 0xFFFFFF");
         sendPosResp(0xFFFFFF);
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_SrvHandler_ReadMileageValue::getMileage => m_pCsmAccessUser == NULL");
   }
   
#endif
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_ReadMileageValue::sendPosResp(tU32 mileage)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadMileageValue::sendPosResp");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

   DIA_TR_INF("dia_SrvHandler_ReadMileageValue::sendPosResp mileage=%d (0x%06X).", mileage, mileage);

   // Sending back the positive answer
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START+0, (mileage >>16)& 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START+1, (mileage >>8 )& 0xFF);
   (void) oDiagMsgBuffer().vSetDataU8 (DATA_START+2, (mileage     )& 0xFF);

   vResReadyAndQuit();
}
