/*
 * dia_SrvHandler_ReadExtendedDataByDTCNumber.cpp
 *
 *  Created on: 03.08.2015
 *      Author: wgl2hi
 */
//   TTFis: DIA_REQ UDS 07 19 06 xx xx xx 01
//   TTFis: DIA_REQ UDS 07 19 06 xx xx xx 02
//   TTFis: DIA_REQ UDS 07 19 06 xx xx xx FF

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES

#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>

#ifndef __INCLUDED_DIA_ERROR_INFO_INTERFACE__
#include <common/framework/errmgmt/dia_ErrorInfoInterface.h>
#endif

// include own class
#include "dia_SrvHandler_ReadExtendedDataByDTCNumber.h"


#define DID_POS                          ((tU8)    2) // DID position in the Message buffer
#define MELEAGE_VALUE_LENGTH             ((tU8)    3) // number bytes of meleage value
#define MELEAGE_DATA_LENGTH              ((tU8)    5) // number bytes of meleage data
#define RECORD_NUMBER_POS                ((tU8)    6) // position of record number in the request
#define UDS_DATAID_RES_LENGTH            ((tU8)    6) /* +n variable */
#define RECORD_NUMBER_REQ_MILEAGE          0x01       // record number of mileage defined by requesting mileage in snapshot data
#define RECORD_NUMBER_REQ_AGEING           0x02       // record number of ageing counter defined by requesting ageing in extended data
#define RECORD_NUMBER_REQ_ALL              0xFF       // record number of ageing counter defined by requesting mileage and ageing
#define RECORD_NUMBER_MILEAGE              0x01       // record number of mileage defined in snapshot data
#define RECORD_NUMBER_AGEING               0x01       // record number of ageing counter defined in extended data

#define PREGRESS_NONE                      0x00
#define PREGRESS_REQUEST_SNAPSHOT          0x01
#define PREGRESS_REQUEST_EXTENDED          0x02
#define PREGRESS_REQUEST_EXTENDED_DONE     0x03

//------------------------------------------------------------------------------

dia_SrvHandler_ReadExtendedDataByDTCNumber::dia_SrvHandler_ReadExtendedDataByDTCNumber (tU8 u8DID  )
   : dia_ServiceHandlerUDS("dia_SrvHandler_ReadExtendedDataByDTCNumber", DIA_C_U8_UDS_SID_READ_DTC_INFO, u8DID),
     m_u8StatusMask(0),
     m_u8RecordNumber(0x00),
     m_u8Progress(PREGRESS_NONE)
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_ReadExtendedDataByDTCNumber::dia_SrvHandler_ReadExtendedDataByDTCNumber()");
}

//------------------------------------------------------------------------------

dia_SrvHandler_ReadExtendedDataByDTCNumber::~dia_SrvHandler_ReadExtendedDataByDTCNumber ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_ReadExtendedDataByDTCNumber::~dia_SrvHandler_ReadExtendedDataByDTCNumber !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//------------------------------------------------------------------------------

void
dia_SrvHandler_ReadExtendedDataByDTCNumber::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_ReadExtendedDataByDTCNumber::vProcessRequest()");

   dia_IErrorLog* pErrorLog = 0;

   result.clear();

   if ( querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS && pErrorLog)
   {
      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      tU8 u8SubId = oDiagMsgBuffer().u8GetData(DID_POS);
      tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();

      if ((u8SubId == UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER) && (dataLength == 7))
      {
         m_u8RecordNumber = oDiagMsgBuffer().u8GetData(RECORD_NUMBER_POS);

         if ((m_u8RecordNumber == RECORD_NUMBER_REQ_MILEAGE) || (m_u8RecordNumber == RECORD_NUMBER_REQ_ALL))
         {
            requestSnapshotData(RECORD_NUMBER_MILEAGE);
         }
         else // request only agein counter
         {
            requestExtendedData(RECORD_NUMBER_AGEING);
         }
      }
      else
      {
         (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
         if (u8SubId != UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER)
         {
            DIA_TR_INF("Invalid subfunction ID: %d<>6", u8SubId);
         }
         else
         {
            DIA_TR_INF("Invalid Length %d<>6", dataLength);
         }
         vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
      }
   }
   else
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      DIA_TR_INF("dia_SrvHandler_ReadExtendedDataByDTCNumber::vProcessRequest querySysAdapterInterface || pErrorLog failed");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_ReadExtendedDataByDTCNumber::requestSnapshotData(tU8 u8RecordNumber)
{
   dia_IErrorLog* pErrorLog = 0;

   if ( querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS && pErrorLog)
   {
      tU32 dtc = ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+1)<<16) + ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+2)<<8) + (oDiagMsgBuffer().u8GetData(DID_POS+3));

      if(pErrorLog->getSnapShotData(DIAGLOG_MEMORY_CUSTOMER, dtc, u8RecordNumber) == DIA_SUCCESS)
      {
         DIA_TR_INF("getDTCbyStatusMask: SUCCESS");
         m_u8Progress = PREGRESS_REQUEST_EXTENDED;
      }
   }

   if (m_u8Progress != PREGRESS_REQUEST_EXTENDED)
   {
      DIA_TR_INF("dia_SrvHandler_ReadExtendedDataByDTCNumber::requestSnapshotData pErrorLog->getSnapShotData failed");
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_ReadExtendedDataByDTCNumber::requestExtendedData(tU8 u8RecordNumber)
{
   dia_IErrorLog* pErrorLog = 0;

   if ( querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS && pErrorLog)
   {
      tU32 dtc = ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+1)<<16) + ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+2)<<8) + (oDiagMsgBuffer().u8GetData(DID_POS+3));

      if(pErrorLog->getExtendedData(DIAGLOG_MEMORY_CUSTOMER, dtc, u8RecordNumber) == DIA_SUCCESS)
      {
         DIA_TR_INF("getExtendedData: SUCCESS");
         m_u8Progress = PREGRESS_REQUEST_EXTENDED_DONE;
      }
   }

   if (m_u8Progress != PREGRESS_REQUEST_EXTENDED_DONE)
   {
      DIA_TR_INF("dia_SrvHandler_ReadExtendedDataByDTCNumber::requestExtendedData pErrorLog->getExtendedData failed");
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_ReadExtendedDataByDTCNumber::vOnDiaglogGetSnapShotDataByDTC ( const tU32 dtc, const tU8 status, std::list<IErrorLogSnapshotDataResult>& snapshotList)
{
   dia_tclFnctTrace trc( "dia_SrvHandler_ReadExtendedDataByDTCNumber::vOnDiaglogGetSnapShotDataByDTC");
//   (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   
   result.push_back(UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER);
   result.push_back((dtc>>16) & 0xFF);
   result.push_back((dtc>>8)  & 0xFF);
   result.push_back((dtc)     & 0xFF);
   result.push_back(status);
   std::list<IErrorLogSnapshotDataResult>::iterator iter = snapshotList.begin();
   std::vector<tU8>::iterator iter2 = iter->data.begin();

   iter2++;
   iter2++;
   // record number of mileage
   result.push_back(iter->recNo);
   // mileage value
   result.push_back(*iter2++);
   result.push_back(*iter2++);
   result.push_back(*iter2);    

   if (m_u8RecordNumber == RECORD_NUMBER_REQ_MILEAGE)
   {
      vSendPositiveResponse((tU16) (1+result.size()), &result);
      tU16 u16ListSize = (tU16) result.size();
      DIA_TR_INF("dia_SrvHandler_ReadExtendedDataByDTCNumber::vOnDiaglogGetSnapShotDataByDTC: result with size = %d", u16ListSize);
   }
   else if (m_u8RecordNumber == RECORD_NUMBER_REQ_ALL)
   {
      requestExtendedData(RECORD_NUMBER_AGEING);
   }
   else
   {
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_ReadExtendedDataByDTCNumber::vOnDiaglogGetExtendedDataByDTC(IErrorLogExtendedDataResult const& aExtendedData)
{
   dia_tclFnctTrace trc( "dia_SrvHandler_ReadExtendedDataByDTCNumber::vOnDiaglogGetExtendedDataByDTC");
   (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   if (m_u8RecordNumber == RECORD_NUMBER_REQ_AGEING)
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DID_POS + (sizeof(tU8) * 3) + sizeof(tU8) + (sizeof(tU8) * 2));
      oDiagMsgBuffer().vSetDataU8(DID_POS, static_cast<tU8>(aExtendedData.dtc >> 16));
      oDiagMsgBuffer().vSetDataU8(DID_POS+1, static_cast<tU8>(aExtendedData.dtc >> 8));
      oDiagMsgBuffer().vSetDataU8(DID_POS+2, static_cast<tU8>(aExtendedData.dtc));
      oDiagMsgBuffer().vSetDataU8(DID_POS+3, aExtendedData.status);
      oDiagMsgBuffer().vSetDataU8(DID_POS+4, RECORD_NUMBER_REQ_AGEING);
      oDiagMsgBuffer().vSetDataU8(DID_POS+5, aExtendedData.data[1]);
      vResReadyAndQuit();
   }
   else // request all
   {
       oDiagMsgBuffer().vSetDataLength(DID_POS + (sizeof(tU8) * 3) + sizeof(tU8) + (sizeof(tU8) * 6));
       result.push_back(RECORD_NUMBER_REQ_AGEING); // using record number defined for request, instead of record number in aExtendedData.data[0]
       result.push_back(aExtendedData.data[1]);
       vSendPositiveResponse((tU16) (1+result.size()), &result);
   }
}
